/***************************************************************************
                           Greedy.cpp
                           ----------
    begin                : Sat Jul 10 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#include <qspinbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include <kdebug.h>
#include <klocale.h>
#include <kconfig.h>

#include "greedy.h"
#include "dscalerfiltergreedy.h"

GreedyPlugin::GreedyPlugin(Kdetv *ktv, const QString& cfgkey, QObject *parent, const char* name)
    : KdetvFilterPlugin(ktv, cfgkey, parent, name)
{
    _filter = new DScalerFilterGreedy();
    static_cast<DScalerFilterGreedy*>(_filter)->_maxComb = _cfg->readNumEntry("MaxComb", MAX_COMB_DEFAULT);
}

GreedyPlugin::~GreedyPlugin()
{
    delete _filter;
}

QWidget* GreedyPlugin::configWidget(QWidget* parent, const char* name)
{
    DScalerFilterGreedy* f = static_cast<DScalerFilterGreedy*>(_filter);

    QFrame *w = new QFrame(parent, name);
    w->setMargin(4);
    QGridLayout *g = new QGridLayout(w, 2, 2);

    g->addWidget(new QLabel(i18n("Maximum comb:"), w), 0, 0);
    _spMaxComb = new QSpinBox(1, 100, 1, w, "MaxCombSpin");
    _spMaxComb->setValue(f->_maxComb);
    g->addWidget(_spMaxComb, 0, 1);

    QButton* b = new QPushButton(i18n("Defaults"), w, "Defaults");
    connect(b, SIGNAL( clicked() ),
            this, SLOT( defaults() ));
    g->addWidget(b, 1, 1);

    return w;
}

void GreedyPlugin::defaults()
{
    DScalerFilterGreedy* f = static_cast<DScalerFilterGreedy*>(_filter);

    f->_maxComb = MAX_COMB_DEFAULT;

    _spMaxComb->setValue(f->_maxComb);
}

void GreedyPlugin::saveConfig()
{
    DScalerFilterGreedy* f = static_cast<DScalerFilterGreedy*>(_filter);

    f->_maxComb = _spMaxComb->value();

    _cfg->writeEntry("MaxComb", f->_maxComb);
    _cfg->sync();
}

extern "C" {
    GreedyPlugin* create_greedy(Kdetv* ktv)
    {
        return new GreedyPlugin(ktv, "deinterlace-greedy", 0, "Greedy deinterlacefilter");
    }
}

#include "greedy.moc"
