// -*- c++ -*-
/***************************************************************************
                           settingsdialogpage.h
                           -------------------
    begin                : Sun Sep 13 2003
    copyright            : (C) 2003 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef SETTINGSDIALOGPAGE_H
#define SETTINGSDIALOGPAGE_H

#include <qstring.h> 
#include <qptrlist.h>

#include "libkdetv_export.h"

/**
 * @author Dirk Ziegelmeier <dziegel@gmx.de>
 * Interface definition of a settings dialog page
 */
class LIBKDETV_EXPORT SettingsDialogPage
{
public: 
    SettingsDialogPage(const QString& pageName, const QString& header, const QString& barIconName);
    virtual ~SettingsDialogPage();

    /**
     * Setup page to reflect supplied configuration
     */
    virtual void setup() = 0;

    /**
     * Apply page's changes to supplied configuration handle
     */
    virtual void apply() = 0;

    /**
     * Reset pages' config options to default values
     */
    virtual void defaults() = 0;

    /**
     * Settings are canceled. Undo changes in here.
     */
    virtual void cancel() {} ;

    /**
     * Do corrections to config values if applicable. Not yet implemented.
     */
    virtual void checkValues() {};

    /**
     * Page name displayed in icon bar
     */
    const QString& pageName() const    { return _pageName; };

    /**
     * Page header
     */
    const QString& header() const      { return _header; };

    /**
     * Icon bar icon file name
     */
    const QString& barIconName() const { return _barIconName; };


private:
    QString _pageName;
    QString _header;
    QString _barIconName;
};

/**
 * A class that produces settings dialog pages. Useful
 * for plugins or clients that want to have an own page.
 */
class LIBKDETV_EXPORT SettingsDialogPageFactory
{
public:

    SettingsDialogPageFactory();
    virtual ~SettingsDialogPageFactory();

    virtual QPtrList<SettingsDialogPage>* getPages() = 0;
};

#endif
