/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *               2004 Dirk Ziegelmeier <dziegel@gmx.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <klocale.h>
#include <kapplication.h>

#include "channel.h"
#include "channel.moc"

Channel::Channel( QObject *parent, const char *name )
    : QObject( parent, name ),
      _num(-1), _enabled(true),
      _url(QString::null), _description(QString::null)
{
}

void Channel::setNumber(int x)
{
    _num = x;
    emit changed();
}

void Channel::setEnabled( bool enabled )
{
    _enabled = enabled;
    emit changed();
}

void Channel::setName( const QString &name )
{
    _name = name;
    emit changed();
}

void Channel::setURL( const QString &url )
{
    _url = url;
    emit changed();
}

void Channel::setDescription( const QString &description )
{
    _description = description;
    emit changed();
}

void Channel::setHasControls(const QString& dev, bool yesno)
{
    _hasControls[dev] = yesno;
    emit changed();
}

void Channel::setControl(const QString& dev, const QString& property, const QVariant& value)
{
    _controls[dev][property] = value;
    emit changed();
}

void Channel::setChannelProperty(const QString& property, const QVariant& value)
{
    _channelProperties[property] = value;
    emit changed();
}

bool Channel::compareChannelProperties(const Channel& other)
{
    PropertyList::const_iterator it;

    for(it = _channelProperties.constBegin(); it != _channelProperties.constEnd(); ++it) {
        if(it.data() != other.getChannelProperty(it.key())) {
            return false;
        }
    }

    for(it = other.channelProperties().constBegin(); it != other.channelProperties().constEnd(); ++it) {
        if(it.data() != getChannelProperty(it.key())) {
            return false;
        }
    }

    return true;
}

Channel& Channel::operator=(const Channel *chan)
{
    _num               = chan->number();
    _enabled           = chan->enabled();
    _name              = chan->name();
    _url               = chan->url();
    _description       = chan->description();
    _hasControls       = chan->_hasControls;
    _controls          = chan->_controls;
    _channelProperties = chan->_channelProperties;
    emit changed();

    return *this;
}

void Channel::updateValues( const QString& name, int num, bool enabled )
{
   _num     = num;
   _enabled = enabled;
   _name    = name;
   emit changed();
}
