#include "src/bookmarks/kz-root-bookmark.h"

#include <gcutter.h>

#include "kz-test-utils.h"

void test_new (void);
void test_add_bookmark_bar_file (void);

static KzRootBookmark *root;
static KzBookmark *expected;
static gchar *bookmark_file;
static gchar *bookmark_bar_file;

void
setup (void)
{
    root =  NULL;
    expected = NULL;

    bookmark_file = g_build_filename(kz_test_get_base_dir(),
                                     "fixtures", "bookmarks.xml",
                                     NULL);
    bookmark_bar_file = g_build_filename(kz_test_get_base_dir(),
                                         "fixtures", "bookmarkbar.xml",
                                         NULL);
}

void
teardown (void)
{
    if (root)
        g_object_unref(root);
    if (expected)
        g_object_unref(expected);

    g_free(bookmark_file);
}

void
test_new (void)
{
    root = kz_root_bookmark_new(bookmark_file, NULL, NULL, NULL);
    cut_assert(root);
    cut_assert_true(kz_bookmark_folder_has_children(KZ_BOOKMARK_FOLDER(root)));

    cut_assert(root->menu);
    cut_assert_equal_string("Bookmarks", kz_bookmark_get_title(root->menu));

    expected = KZ_BOOKMARK(kz_bookmark_file_new(bookmark_file, "Bookmarks", "XBEL"));

    kz_assert_equal_bookmark(expected, root->menu);
}

void
test_add_bookmark_bar_file (void)
{
    cut_trace(test_new());

    kz_root_bookmark_add_bookmark_bar_file(root, bookmark_bar_file, NULL);

    expected = kz_bookmark_folder_new(NULL);
    kz_bookmark_folder_append(KZ_BOOKMARK_FOLDER(expected),
                              KZ_BOOKMARK(kz_bookmark_file_new(bookmark_bar_file, "Bookmark Bar", "XBEL")));

    kz_assert_equal_bookmark(expected, root->bookmark_bars);
}

/*
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
