/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 *  Copyright (C) 2009 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_SITE_H__
#define __KZ_SITE_H__

#include <glib.h>

G_BEGIN_DECLS

typedef struct _KzSite      KzSite;
struct _KzSite {
    gchar *uri;
    gchar *title;
};

KzSite *kz_site_new       (const gchar *title,
                           const gchar *uri);
void    kz_site_free      (KzSite *site);
void    kz_site_list_free (GList *list);


G_END_DECLS

#endif /* __KZ_SITE_H__ */
/* 
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
