/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 *  Copyright (C) 2009 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-site.h"

KzSite *
kz_site_new (const gchar *title, const gchar *uri)
{
    KzSite *site;

    site = g_slice_new0(KzSite);
    site->title = g_strdup(title);
    site->uri = g_strdup(uri);
    return site;
}

void
kz_site_free (KzSite *site)
{
    if (!site)
        return;
    g_free(site->title);
    g_free(site->uri);
    g_slice_free(KzSite, site);
}

void
kz_site_list_free (GList *list)
{
    if (!list)
        return;
    g_list_foreach(list, (GFunc)kz_site_free, NULL);
    g_list_free(list);
}

/* 
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
