/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 *  Copyright (C) 2009 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_PASSWORD_INFO_H__
#define __KZ_PASSWORD_INFO_H__

#include <glib.h>

G_BEGIN_DECLS

typedef struct _KzPasswordInfo      KzPasswordInfo;
struct _KzPasswordInfo {
    gchar *uri;
    gchar *user_name;
};

KzPasswordInfo *kz_password_info_new       (const gchar *uri,
                                            const gchar *user_name);
void            kz_password_info_free      (KzPasswordInfo *password_info);
void            kz_password_info_list_free (GList *list);

G_END_DECLS

#endif /* __KZ_PASSWORD_INFO_H__ */
/* 
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
