/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_SEARCH_COMMON_H__
#define __KZ_SEARCH_COMMON_H__

#include <glib.h>

G_BEGIN_DECLS

#define DTD   "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">"
#define HEAD  "<head>\n" \
	      "  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n" \
	      "  <title>%s - Full-text search in history</title>\n" \
	      "  <link rel=\"stylesheet\" type=\"text/css\" href=\"history-search:?css=search-result.css\">\n" \
	      "  <script type=\"text/javascript\" src=\"history-search:?css=search-result.js\"></script>\n" \
	      "</head>\n"
#define HEADER  ""
#define CONTENT "<div class=\"content\">\n" \
	        "  <div class=\"header\"><span class=\"title\"><a href=\"%s\">%s</a></span></div>\n" \
		"    <div class=\"summary\"><img src=\"%s\" class=\"thumbnail\">\n" \
		"    <span class=\"sentence\">%s</span>\n" \
		"  </div>\n" \
		"  <div class=\"footer\">\n" \
		"    <span class=\"uri\">%s</span>\n" \
		"    %s\n" \
		"    <span class=\"date\">%s</span>\n" \
		"  </div>\n" \
		"</div>\n"
#define FOOTER  "<div class=\"footer\">\n" \
	        "Powered by <a href=\"%s\">%s</a> version %s\n" \
		"</div>\n"

G_END_DECLS


typedef struct {
    unsigned int mask;
    char *exp;
} KZ_SEARCH_FLAG;

#define KZ_SEARCH_FLAG_GROUP_OPERATOR	0x0000000f
#define KZ_SEARCH_FLAG_MASK_NOT		0x00000001
#define KZ_SEARCH_FLAG_GROUP_OPTION	0x000000f0		/* exclusive */
#define KZ_SEARCH_FLAG_MASK_SITE	0x00000010

//NOTE: synchronize FLAG_NUMBER and FLAGS order
enum KZ_SEARCH_FLAG_NUMBER {
	KZ_SEARCH_FLAG_NOT,
	KZ_SEARCH_FLAG_SITE
};

KZ_SEARCH_FLAG KZ_SEARCH_FLAGS[] = {
    { KZ_SEARCH_FLAG_MASK_NOT, "-"},
    { KZ_SEARCH_FLAG_MASK_SITE, "site:"}
};

#define KZ_SEARCH_FLAG_SIZE (sizeof(KZ_SEARCH_FLAGS)/sizeof(KZ_SEARCH_FLAG))



#endif /* __KZ_SEARCH_COMMON_H__ */
