/*
    gbxsystem.cpp - Game Boy/Game Boy Color Kamefu system plugin

    Copyright (c) 2006      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "gbxsystem.h"

// KDE Includes
#include <kgenericfactory.h>
#include <kdebug.h>

// Kamefu includes
#include "rommetadatafactory.h"

#include "gbxrommetadata.h"

typedef KGenericFactory<GbxSystem> GbxSystemFactory;
K_EXPORT_COMPONENT_FACTORY( kamefu_gbx, GbxSystemFactory( "kamefu_gbx" )  )

class GbxSystem::Private
{
};

GbxSystem::GbxSystem(QObject *parent, const char *name, const QStringList& /*args*/)
 : Kamefu::System(parent, name)
{
	
	if ( s_gbxSystem )
		kdDebug()<< k_funcinfo << "GBX system already initialized" << endl;
	else
		s_gbxSystem = this;

	d = new Private;

	registerSystemMimeType( QString::fromUtf8("application/x-rom-gbx") );
	Kamefu::RomMetaDataFactory::self()->addRomMetaDataFactory( QString::fromUtf8("application/x-rom-gbx"), new GbxRomMetaData);
}


GbxSystem::~GbxSystem()
{
	delete d;
	s_gbxSystem = 0L;	
}

GbxSystem *GbxSystem::system()
{
	return s_gbxSystem;
}

GbxSystem *GbxSystem::s_gbxSystem = 0L;

#include "gbxsystem.moc"
