/*
    firsttimewizardpage2.cpp - Kamefu first-time wizard.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "firsttimewizardpage2.h"

// Qt includes
#include <qlayout.h>
#include <qcheckbox.h>
#include <qstringlist.h>
#include <qtimer.h>
#include <qlabel.h>
#include <qframe.h>

// KDE includes
#include <klocale.h>

// Kamefu includes
#include <kcheckdirectoryselector.h>
#include <kamefupreferences.h>

using namespace Kamefu::UI;

class FirstTimeWizardPage2::Private
{
public:
	Private()
		: dirSelect(0), checkRecursive(0)
	{}

	~Private()
	{
		dirSelect->deleteLater();
		checkRecursive->deleteLater();
	}

	KCheckDirectorySelector *dirSelect;
	QCheckBox *checkRecursive;
};

FirstTimeWizardPage2::FirstTimeWizardPage2(QWidget *parent, const char *name)
 : QWidget(parent, name), d(new Private())
{
	QVBoxLayout *layout = new QVBoxLayout(this);

	d->dirSelect = new KCheckDirectorySelector(this, "dirSelect");
	d->checkRecursive = new QCheckBox(i18n("Scan into subdirectories"), this);

	layout->addWidget(d->dirSelect);
	layout->addWidget(d->checkRecursive);

	// Load settings after creation of the page2.
	QTimer::singleShot(0, this, SLOT(loadSettings()));
}

FirstTimeWizardPage2::~FirstTimeWizardPage2()
{
	delete d;
}

void FirstTimeWizardPage2::loadSettings()
{
	bool recursive = KamefuPreferences::self()->collectionRecursive();
	d->dirSelect->setRecursive(recursive);
	d->checkRecursive->setChecked(recursive);

	d->dirSelect->setDirs(KamefuPreferences::self()->collectionDirectories());
}

bool FirstTimeWizardPage2::recursiveSelected() const
{
	return d->checkRecursive->isChecked();
}

QStringList FirstTimeWizardPage2::directoriesSelected() const
{
	return d->dirSelect->dirs();
}


#include "firsttimewizardpage2.moc"
