#! /bin/sh

# When in clone of Git repository (see Vcs-Git in debian/control), one may use
# this script for building kadu-mime-tex package

set -e

n=$(expr $(head -1 debian/changelog | awk '{printf $2}' | /usr/bin/wc -c) - 1)
version=$(head -1 debian/changelog | awk '{printf $2}' | cut -b2-$n)
upstream_version=$(echo $version | awk -F "-" '{printf $1}')
debian_revision=$(echo $version | awk -F "-" '{printf $2}')

git clean -d -f -x
git reset --hard
git br -D build || true
git co -b build upstream
git merge -m "Merging debian" debian

debuild -us -uc -I.git $@

