#!/bin/sh
# Simple wrapper script used to start JOSM in Debian
set -e

# First, the alternative (if known to work) or users preference as defined by $JAVA_HOME. Next, use OpenJDK or Sun's proprietary JDK.
# Override to a specific one using $JAVACMD
ALTERNATIVE_JDK="`readlink -n -f /etc/alternatives/java`"
JAVA_CMDS="$JAVA_HOME/bin/java /usr/lib/jvm/java-6-openjdk/bin/java /usr/lib/jvm/java-6-sun/bin/java /usr/lib/jvm/java-1.5.0-sun/bin/java"
JAVA_OPTS="$JAVA_OPTS -Djava.net.preferIPv4Stack=true"

for jcmd in $JAVA_CMDS; do
	if [ "z$ALTERNATIVE_JDK" = "z`readlink -n -f $jcmd`" ] && [ -z "${JAVACMD}" ]; then
        JAVACMD="$jcmd"
    fi
done

for jcmd in $JAVA_CMDS; do
    if [ -x "$jcmd" -a -z "${JAVACMD}" ]; then
        JAVACMD="$jcmd"
    fi
done

if [ "$JAVACMD" ]; then
    echo "Using $JAVACMD to execute josm."
    exec $JAVACMD $JAVA_OPTS -jar /usr/share/josm/josm.jar "$@"
else
    echo "No valid JVM found to run JOSM."
    exit 1
fi
