/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  This is base class for all parallellizable pipelines
//

#ifndef IVIEWSUBJECTPIPELINE_H
#define IVIEWSUBJECTPIPELINE_H


#include "igenericfilter.h"
#include <vtkDataSetToPolyDataFilter.h>


#include "iarray.h"


class iViewSubjectPipeline : public iGenericFilter<vtkDataSetToPolyDataFilter,vtkDataSet,vtkPolyData>
{

public:

	enum Component
	{
		_All,
		_Replicas,
		__Last
	};

	vtkTypeMacro(iViewSubjectPipeline,vtkDataSetToPolyDataFilter);

	virtual void UpdateContents(int n, int info = 0) = 0;

	virtual float GetMemorySize();

	void SetGlobalInput(vtkDataSet *input);
	vtkDataSet* GetGlobalInput() const { return mGlobalInput; }

	virtual void SetNthInput(int num, vtkDataObject *input); // vtkProcessObject::SetNthInput(num,input) is protected

	//
	//  Removes the data used internally. The data will be re-created when pipeline is executed the next time, but
	//  in the mean time the pipeline will use less memory.
	//
	void RemoveInternalData(bool keepOutputs = true);

	//
	//  Do some work serially after the parallel execution is completed.
	//
	virtual void SerialPostProcess(int){}

protected:

	iViewSubjectPipeline(iViewSubject *vo, int numInputs);
	~iViewSubjectPipeline();

	//
	//  This function should be used to create all filters. Then they will be deleted automatically
	//  and Clear() will automatically remove the data a filter uses.
	//
	template<class Filter> Filter* CreateFilter();
	//
	//  This function can be used in case a child class wants to remove a filter. 
	//  Filters created with CreateFilter are deleted automatically together with the pipeline, 
	//  normally so there is no need to use this function.
	//
	template<class Filter> void DeleteFilter(Filter *filter);

	virtual float GetContentsMemorySize() const = 0;
	virtual void RemoveInternalDataForExtraComponents(bool keepOutputs);

	vtkDataSet *mGlobalInput;
	iSearchableArray<vtkAlgorithm*> mInternalFilters;
};

#endif  // IVIEWSUBJECTPIPELINE_H
