/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggdialogfilesetexplorer.h"


#include "icontrolmodule.h"
#include "idata.h"
#include "idatareader.h"
#include "idirectory.h"
#include "ierrorstatus.h"
#include "ihelpfactory.h"
#include "iimagefactory.h"
#include "ishell.h"
#include "iviewmodule.h"

#include "iggframe.h"
#include "iggmainwindow.h"
#include "iggwidgetotherbutton.h"
#include "iggwidgettext.h"

#include "ibgwidgetbuttonsubject.h"
#include "ibgwidgettexteditorsubject.h"

#include "iggsubjectfactory.h"

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"


using namespace iParameter;


namespace iggDialogFileSetExplorer_Private
{
	class View : public iggWidgetListView
	{

	public:

		View(iggDialogFileSetExplorer *dialog, iggFrame *parent) : iggWidgetListView(false,parent)
		{
			mDialog = dialog;
			mCurrentEntry = -1;
			mBlockUpdates = false;
		}

	protected:

		virtual void UpdateWidgetBody()
		{
			static const iColor current = iColor(0,0,255);

			if(mBlockUpdates) return;

			iDataReader *dr = this->GetShell()->GetControlModule()->GetViewModule()->GetReader();

			if(dr->IsSet())
			{
				int i, j, n;
				if(!mDir.Open(dr->GetLastFileSetName()))
				{
					this->GetMainWindow()->PopupWindow(mDialog->GetFrame(),"Unable to open directory containing "+dr->GetLastFileSetName()+" file.",PopupWindow::Error);
					this->Clear();
					mDialog->MustBeClosed();
					return;
				}

				bool redo = (mCurrentEntry==-1 || mDir.GetFile(mCurrentEntry,true)!=dr->GetLastFileSetName());
				n = mDir.GetNumberOfFiles();
				iString ws;
				for(i=j=0; !redo && i<n; i++)
				{
					if(dr->IsAnotherSetLeader(mDir.GetFile(i,true)))
					{
						ws = this->GetItem(j);
						ws.ReduceWhiteSpace();
						if(mDir.GetFile(i,false) != ws)
						{
							redo = true;
						}
						j++;
					}
				}

				if(redo)
				{
					mCurrentEntry = -1;
					this->Clear();
					for(i=j=0; i<n; i++)
					{
						if(dr->IsAnotherSetLeader(mDir.GetFile(i,true)))
						{
							if(mDir.GetFile(i,true) == dr->GetLastFileSetName())
							{
								mCurrentEntry = j;
								mSubject->SetBoldText(true);
								this->InsertItem(mDir.GetFile(i,false),current);
								mSubject->SetBoldText(false);
							}
							else
							{
								this->InsertItem(mDir.GetFile(i,false));
							}
							j++;
						}
					}
					if(mCurrentEntry >= 0)
					{
						this->Select(mCurrentEntry,mCurrentEntry);
					}
				}
			}
			else this->Clear();

			this->iggWidgetListView::UpdateWidgetBody();
		}

		virtual void OnReturnPressed()
		{
			int i, imin = mSelectedRange[0], imax = mSelectedRange[1];
			iString ws;

			mBlockUpdates = true;
			for(i=imin; i<=imax; i++)
			{
				ws = mDir.GetDirectoryPrefix() + mSubject->GetLine(i);
				ws.ReduceWhiteSpace(); // needed for some bizarre reason
				mDialog->LoadData(ws);
			}
			mBlockUpdates = false;
			this->UpdateWidget();
		}

		iggDialogFileSetExplorer *mDialog;
		iDirectory mDir;
		int mCurrentEntry;
		bool mBlockUpdates;
	};

	//
	//  Load all 
	//
	class LoadAllCheckBox : public iggWidget
	{

	public:

		LoadAllCheckBox(iggDialogFileSetExplorer *dialog, iggFrame *parent) : iggWidget(parent)
		{
			mDialog = dialog;
			mButton = iggSubjectFactory::CreateWidgetButtonSubject(this,ButtonType::CheckBox,"Load data for all windows",1);

			this->SetBaloonHelp("Load data for all visualization windows");
		}

	protected:

		virtual void UpdateWidgetBody()
		{
			mButton->SetDown(mDialog->GetLoadAll());
		}

		virtual void OnVoid1Body()
		{
			mDialog->SetLoadAll(mButton->IsDown());
		}

		ibgWidgetButtonSubject *mButton;
		iggDialogFileSetExplorer *mDialog;
	};


	class RefreshButton : public iggWidgetSimpleButton
	{

	public:

		RefreshButton(iggDialogFileSetExplorer *dialog, iggFrame *parent) : iggWidgetSimpleButton("Refresh",parent)
		{
			mDialog = dialog;
		
			this->SetBaloonHelp("Refresh file list","Refresh the list of files in case they changed on disk.");
		}

	protected:

		virtual void Execute()
		{
			mDialog->UpdateDialog();
		}

		iggDialogFileSetExplorer *mDialog;
	};
};


using namespace iggDialogFileSetExplorer_Private;


iggDialogFileSetExplorer::iggDialogFileSetExplorer(iggMainWindow *parent) : iggDialog(parent,0U,iImageFactory::FindIcon("setexp.png"),"File Set Explorer","sr.gg.df",3)
{
	mMustBeClosed = false;
	mLoadAll = true;

	mView = new View(this,mFrame);
	mFrame->AddLine(mView,3);
	mFrame->AddLine(new LoadAllCheckBox(this,mFrame),(iggWidget *)0,new RefreshButton(this,mFrame));

	this->ResizeContents(300,400);
}


void iggDialogFileSetExplorer::UpdateDialog()
{
	if(!this->GetShell()->GetControlModule()->GetViewModule()->GetReader()->IsSet())
	{
		this->Show(false);
	}
	else
	{
		iggDialog::UpdateDialog();
	}
}


void iggDialogFileSetExplorer::Show(bool s)
{
	mMustBeClosed = false;
	iggDialog::Show(s);
	if(mMustBeClosed) iggDialog::Show(false);
}


void iggDialogFileSetExplorer::MustBeClosed()
{
	mMustBeClosed = true;
}


void iggDialogFileSetExplorer::LoadData(const iString &fname)
{
	//
	//  Load current first
	//
	iDataReader *dr = this->GetShell()->GetControlModule()->GetViewModule()->GetReader();

	this->GetMainWindow()->LoadData(dr->GetFileSetDataType(),fname);

	if(mLoadAll && dr->GetErrorStatus()->NoError())
	{
		int i, n = this->GetShell()->GetControlModule()->GetNumberOfViewModules();
		int rec = dr->GetRecordNumber();
		iString ws;
		iViewModule *vm;
		for(i=0; i<n; i++) if(i != this->GetShell()->GetControlModule()->GetCurrentViewModuleIndex())
		{
			vm = this->GetShell()->GetControlModule()->GetViewModule(i);
			ws = vm->GetReader()->GetFileSetName(rec);
			if(!ws.IsEmpty())
			{
				this->GetMainWindow()->LoadData(vm->GetReader()->GetFileSetDataType(),ws,i);
				if(vm->GetReader()->GetErrorStatus()->NoError()) vm->Render();
			}
		}
	}
}

#endif
