/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  DataFileLoader for reading basic particle files
//
#ifndef IBASICPARTICLESFILELOADER_H
#define IBASICPARTICLESFILELOADER_H


#include "iparticlefileloader.h"


class iBasicParticlesFileLoader : public iParticleFileLoader
{

	friend class iDataReader;

public:

	vtkTypeMacro(iBasicParticlesFileLoader,iParticleFileLoader);

protected:

	iBasicParticlesFileLoader(iDataReader *r);

	virtual void ReadFileBody(const iString &suffix, const iString &fname);

	virtual bool ReadBinFileHeader(iFile &F, vtkIdType &ntot0, float *ll, float *ur, bool &paf, int &natt);
	virtual bool ReadTxtFileHeader(iFile &F, vtkIdType &ntot0, float *ll, float *ur, bool &paf, int &natt, iString &buffer);
	virtual bool ReadBinFileContents(iFile &F, bool paf, float *scaleF, float *offsetF, double *scaleD, double *offsetD);
	virtual bool ReadTxtFileContents(iFile &F, bool paf, float *scaleF, float *offsetF, double *scaleD, double *offsetD, iString buffer);
};

#endif

