/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMedia.h"

#include "KURL.h"
#include "Media.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMedia);

/* Hash table */

static const HashTableValue JSMediaTableValues[3] =
{
    { "type", DontDelete|ReadOnly, (intptr_t)jsMediaType, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsMediaConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMediaTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSMediaTableValues, 0 };
#else
    { 4, 3, JSMediaTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSMediaConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMediaConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSMediaConstructorTableValues, 0 };
#else
    { 1, 0, JSMediaConstructorTableValues, 0 };
#endif

class JSMediaConstructor : public DOMConstructorObject {
public:
    JSMediaConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSMediaConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSMediaPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSMediaConstructor::s_info = { "MediaConstructor", 0, &JSMediaConstructorTable, 0 };

bool JSMediaConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaConstructor, DOMObject>(exec, &JSMediaConstructorTable, this, propertyName, slot);
}

bool JSMediaConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMediaConstructor, DOMObject>(exec, &JSMediaConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSMediaPrototypeTableValues[2] =
{
    { "matchMedium", DontDelete|Function, (intptr_t)jsMediaPrototypeFunctionMatchMedium, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMediaPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSMediaPrototypeTableValues, 0 };
#else
    { 2, 1, JSMediaPrototypeTableValues, 0 };
#endif

const ClassInfo JSMediaPrototype::s_info = { "MediaPrototype", 0, &JSMediaPrototypeTable, 0 };

JSObject* JSMediaPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMedia>(exec, globalObject);
}

bool JSMediaPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSMediaPrototypeTable, this, propertyName, slot);
}

bool JSMediaPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSMediaPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSMedia::s_info = { "Media", 0, &JSMediaTable, 0 };

JSMedia::JSMedia(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Media> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSMedia::~JSMedia()
{
    forgetDOMObject(this, impl());
}

JSObject* JSMedia::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSMediaPrototype(JSMediaPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSMedia::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMedia, Base>(exec, &JSMediaTable, this, propertyName, slot);
}

bool JSMedia::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMedia, Base>(exec, &JSMediaTable, this, propertyName, descriptor);
}

JSValue jsMediaType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMedia* castedThis = static_cast<JSMedia*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Media* imp = static_cast<Media*>(castedThis->impl());
    return jsString(exec, imp->type());
}

JSValue jsMediaConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMedia* domObject = static_cast<JSMedia*>(asObject(slot.slotBase()));
    return JSMedia::getConstructor(exec, domObject->globalObject());
}
JSValue JSMedia::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsMediaPrototypeFunctionMatchMedium(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSMedia::s_info))
        return throwError(exec, TypeError);
    JSMedia* castedThisObj = static_cast<JSMedia*>(asObject(thisValue));
    Media* imp = static_cast<Media*>(castedThisObj->impl());
    const UString& mediaquery = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->matchMedium(mediaquery));
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Media* object)
{
    return getDOMObjectWrapper<JSMedia>(exec, globalObject, object);
}
Media* toMedia(JSC::JSValue value)
{
    return value.inherits(&JSMedia::s_info) ? static_cast<JSMedia*>(asObject(value))->impl() : 0;
}

}
