/*
 * This file is part of hyantes.
 *
 * hyantes is free software; you can redistribute it and/or modify
 * it under the terms of the CeCILL-C License
 *
 * You should have received a copy of the CeCILL-C License
 * along with this program.  If not, see <http://www.cecill.info/licences>.
 */

#include "module.h"
#include "engine.h"

#include "pthread_adapt.h"

#include <unistd.h>

/* SG: BAD */
#define USE_LINUX

static int get_processes_max()
{
#if defined USE_LINUX
    return sysconf(_SC_NPROCESSORS_CONF);
#elif defined USE_DARWIN
    int maxproc = 0;
    int mib[2]
    {
    CTL_HW, HW_NCPU};
    size_t len = sizeof(maxproc);
    sysctl(mib, 2, &maxproc, &len, 0, 0);
    return maxproc;
#else
#error "unsupported architecture"
#endif
}

int make_all_pot(hs_potential_t * iter, size_t nb_iter,
   const struct make_pot_param *param)
{
    return adapt_transform(iter, nb_iter, param, get_processes_max());
}


int init_module(va_list * ap)
{
    return ap == NULL ? 1 : 0;
}
