/*
 * This file is part of hyantes.
 *
 * hyantes is free software; you can redistribute it and/or modify
 * it under the terms of the CeCILL-C License
 *
 * You should have received a copy of the CeCILL-C License
 * along with this program.  If not, see <http://www.cecill.info/licences>.
 */

#ifndef _HYANTES_QUADTREE_H
#define _HYANTES_QUADTREE_H

#include "hyantes.h"
#include "read_input.h"

/** 
* @brief strucutre containing transient representation of
* stocks, as a tree with four children
*/
struct qt
{
    /*@null@ *//*@dependent@ */ struct qt *fhg;
                                /**< pointer to the top left child, can be NULL*/
    /*@null@ *//*@dependent@ */ struct qt *fhd;
                                /**< pointer to the top right child, can be NULL*/
    /*@null@ *//*@dependent@ */ struct qt *fbg;
                                /**< pointer to the bottom left child, can be NULL*/
    /*@null@ *//*@dependent@ */ struct qt *fbd;
                                /**< pointer to the bottom right child, can be NULL*/
    double value; /**< cumulated value of all children's stock */
    hs_coord_t coords; /**< coordinate of the area, or of the stock if the quadtree has no child */
    size_t size; /**< number of children (including children of children ...)  of the quadtree */
};
typedef struct qt *QuadT;

/* fills TREE using STOCKS data set */
int build_quadtree(const Stock * stocks, size_t stocksize, QuadT tree)
/*@modifies tree@*/
;

void free_quadtree();

#endif
