/** 
* @file options.c
* @brief lib options part
* @author serge guelton
* @date 2008-07-13
*
* This file is part of hyantes.
*
* hyantes is free software; you can redistribute it and/or modify
* it under the terms of the CeCILL-C License
*
* You should have received a copy of the CeCILL-C License
* along with this program.  If not, see <http://www.cecill.info/licences>.
*/

#include "hyantes.h"
#include "options.h"
#include "module.h"
#include "interpolation.h"

#include <stdarg.h>

/** if not null, the file to write serialized quadtree into */
FILE *g_file_serialize = NULL;

/** value of the threshold used for improved quadtree walkthrough */
double g_threshold = 0.01f;

/** if 1, we use unserialized data, if 0, we used serialized data */
int g_is_raw_data = 1;


/** 
* @brief set various option for the library
* 
* @param opt type of the option to set
* 
* @return 0 if an error occured, 1 otherwise
*/
int hs_set(hs_option_t opt, ...)
{
    va_list ap;
    int res = 1;
    va_start(ap, opt);
    switch (opt)
    {
    case HS_PARSE_ONLY:
        g_file_serialize = va_arg(ap, FILE *);
        break;
    case HS_THRESHOLD:
        g_threshold = va_arg(ap, double);
        break;
    case HS_LOAD_RAW:
        g_is_raw_data = 1;
        break;
    case HS_LOAD_PRECOMPUTED:
        g_is_raw_data = 0;
        break;
    case HS_SMOOTH_FUNC:
        {
            char *fname = va_arg(ap, char *);
            double fparam = va_arg(ap, double);
            set_func_inter(fname, fparam);
        } break;
    case HS_MODULE_OPT:
        res = init_module(&ap);
        break;

    default:
        fprintf(stderr, "[hs_set] unknow option \n");
        res = 0;
    };
    va_end(ap);
    return res;
}
