#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <clutter-gtk/clutter-gtk.h>

#include "hrn-window.h"
#include "hrn-state-manager.h"
#include "hrn.h"

enum {
    PROP_0,
};

struct _HrnWindowPrivate {
    GtkClutterEmbed *embed;
    ClutterActor *internal;
    HrnStateManager *state_manager;
};

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HRN_TYPE_WINDOW, HrnWindowPrivate))
G_DEFINE_TYPE (HrnWindow, hrn_window, GTK_TYPE_WINDOW);

static void
hrn_window_finalize (GObject *object)
{
    G_OBJECT_CLASS (hrn_window_parent_class)->finalize (object);
}

static void
hrn_window_dispose (GObject *object)
{
    G_OBJECT_CLASS (hrn_window_parent_class)->dispose (object);
}

static void
hrn_window_set_property (GObject      *object,
                          guint         prop_id,
                          const GValue *value,
                          GParamSpec   *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static void
hrn_window_get_property (GObject    *object,
                          guint       prop_id,
                          GValue     *value,
                          GParamSpec *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static int
hrn_window_key_press_event (GtkWidget   *widget,
                            GdkEventKey *event)
{
    GtkWindow *window = GTK_WINDOW (widget);

    if (event->state & GDK_CONTROL_MASK &&
        event->keyval == GDK_q) {
        hrn_quit ();
        return TRUE;
    }

    return gtk_window_propagate_key_event (window, event);
}

static void
hrn_window_class_init (HrnWindowClass *klass)
{
    GObjectClass *o_class = (GObjectClass *) klass;
    GtkWidgetClass *w_class = (GtkWidgetClass *) klass;

    o_class->dispose = hrn_window_dispose;
    o_class->finalize = hrn_window_finalize;
    o_class->set_property = hrn_window_set_property;
    o_class->get_property = hrn_window_get_property;

    w_class->key_press_event = hrn_window_key_press_event;

    g_type_class_add_private (klass, sizeof (HrnWindowPrivate));
}

static void
on_stage_resize (GObject *object,
                 GParamSpec *pspec,
                 gpointer    userdata)
{
    ClutterActor *stage = CLUTTER_ACTOR (object);
    GList *children = clutter_container_get_children (CLUTTER_CONTAINER (stage));
    ClutterActor *internal_child;
    ClutterGeometry stage_geom;

    if (!children) {
        return;
    }

    clutter_actor_get_geometry (stage, &stage_geom);

    internal_child = children->data;
    g_list_free (children);

    clutter_actor_set_size (internal_child, stage_geom.width,
                            stage_geom.height);
}

static void
hrn_window_init (HrnWindow *self)
{
    HrnWindowPrivate *priv;
    ClutterActor *stage;
    GError *error = NULL;

    priv = GET_PRIVATE (self);
    self->priv = priv;

    gtk_window_set_icon_from_file ((GtkWindow *) self,
                                   THEMEDIR "/hornsey.png", &error);
    if (error) {
        g_warning ("Error setting window icon: %s", error->message);
        g_error_free (error);
    }

    priv->embed = GTK_CLUTTER_EMBED (gtk_clutter_embed_new ());
    gtk_container_add (GTK_CONTAINER (self), GTK_WIDGET (priv->embed));
    gtk_widget_show (GTK_WIDGET (priv->embed));

    stage = gtk_clutter_embed_get_stage (priv->embed);
    g_signal_connect (G_OBJECT (stage),
                      "notify::allocation", G_CALLBACK (on_stage_resize),
                      NULL);
}

HrnWindow *
hrn_window_new (HrnStateManager *manager)
{
    HrnWindow *window;
    HrnWindowPrivate *priv;

    window = g_object_new (HRN_TYPE_WINDOW, NULL);
    priv = window->priv;

    priv->state_manager = manager;

    return window;
}

void
hrn_window_fullscreen (HrnWindow *self)
{
#ifndef DISABLE_MUTTER_MOBLIN_FULLSCREEN_HACK
  GdkScreen *screen = gdk_screen_get_default ();
  gint width, height;

  /* XXX: This is a hack so that mutter doesn't disable the panel as it would
   * for a real fullscreen window.
   *
   * I don't know what would happen if the user were e.g. using RandR to group
   * multiple displays under one screen.
   *
   * It might be better to instead set a special _MOBLIN_FULLSCREEN_PROPERTY
   */
  gtk_window_set_decorated (GTK_WINDOW (self), FALSE);
  width = gdk_screen_get_width (screen);
  height = gdk_screen_get_height (screen);
  gtk_window_resize (GTK_WINDOW (self), width, height);
#else
  gtk_window_fullscreen (GTK_WINDOW (self));
#endif
}

ClutterActor *
hrn_window_get_stage (HrnWindow *self)
{
    HrnWindowPrivate *priv = self->priv;

    return gtk_clutter_embed_get_stage (priv->embed);
}

void
hrn_window_set_internal_actor (HrnWindow    *self,
                               ClutterActor *actor)
{
    HrnWindowPrivate *priv = self->priv;
    ClutterActor *stage = gtk_clutter_embed_get_stage (priv->embed);

    if (priv->internal == actor) {
        return;
    }

    if (priv->internal) {
        clutter_container_remove_actor (CLUTTER_CONTAINER (stage),
                                        priv->internal);
    }

    if (actor) {
        priv->internal = actor;
        clutter_container_add_actor (CLUTTER_CONTAINER (stage), actor);
    }
}

void
hrn_window_present (HrnWindow *window)
{
  gdk_window_focus (gtk_widget_get_window (GTK_WIDGET (window)), 
                    gtk_get_current_event_time ());
}

