#ifndef __HRN_UI_CONTROLS_H__
#define __HRN_UI_CONTROLS_H__

#include <clutter/clutter.h>

#include <hrn-sidebar.h>
#include <hrn-toolbar.h>

G_BEGIN_DECLS

#define HRN_TYPE_UI_CONTROLS                                            \
   (hrn_ui_controls_get_type())
#define HRN_UI_CONTROLS(obj)                                            \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                HRN_TYPE_UI_CONTROLS,                   \
                                HrnUiControls))
#define HRN_UI_CONTROLS_CLASS(klass)                                    \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             HRN_TYPE_UI_CONTROLS,                      \
                             HrnUiControlsClass))
#define IS_HRN_UI_CONTROLS(obj)                                         \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                HRN_TYPE_UI_CONTROLS))
#define IS_HRN_UI_CONTROLS_CLASS(klass)                                 \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             HRN_TYPE_UI_CONTROLS))
#define HRN_UI_CONTROLS_GET_CLASS(obj)                                  \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               HRN_TYPE_UI_CONTROLS,                    \
                               HrnUiControlsClass))

typedef struct _HrnUiControlsPrivate HrnUiControlsPrivate;
typedef struct _HrnUiControls      HrnUiControls;
typedef struct _HrnUiControlsClass HrnUiControlsClass;

struct _HrnUiControls
{
    ClutterGroup parent;

    HrnUiControlsPrivate *priv;
};

struct _HrnUiControlsClass
{
    ClutterGroupClass parent_class;
};

GType hrn_ui_controls_get_type (void) G_GNUC_CONST;

void hrn_ui_controls_set_position (HrnUiControls *controls,
                                   double         value);
HrnToolbar *hrn_ui_controls_get_toolbar (HrnUiControls *controls);
HrnSidebar *hrn_ui_controls_get_sidebar (HrnUiControls *controls);
void hrn_ui_controls_unpin_sidebar (HrnUiControls *controls);

void hrn_ui_controls_set_zoom (HrnUiControls *controls,
                               HrnZoomLevel   zoom_level);

void hrn_ui_controls_hide (HrnUiControls *controls);
void hrn_ui_controls_show (HrnUiControls *controls);
void hrn_ui_controls_set_query (HrnUiControls *controls,
                                const char    *query);
void hrn_ui_controls_set_enabled (HrnUiControls *controls,
                                  gboolean       enabled);
void hrn_ui_controls_show_queue (HrnUiControls *controls,
                                 gboolean       shown);


G_END_DECLS

#endif /* __HRN_UI_CONTROLS_H__ */
