#ifndef __HRN_TOOLBAR_H__
#define __HRN_TOOLBAR_H__

#include <nbtk/nbtk.h>
#include <bickley/bkl-item.h>
#include "hrn-pin-manager.h"

G_BEGIN_DECLS

#define HRN_TYPE_TOOLBAR                                                \
  (hrn_toolbar_get_type ())
#define HRN_TOOLBAR(obj)                                                \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                               HRN_TYPE_TOOLBAR,                       \
                               HrnToolbar))
#define HRN_TOOLBAR_CLASS(klass)                                        \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                            HRN_TYPE_TOOLBAR,                          \
                            HrnToolbarClass))
#define IS_HRN_TOOLBAR(obj)                                             \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                               HRN_TYPE_TOOLBAR))
#define IS_HRN_TOOLBAR_CLASS(klass)                                     \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                            HRN_TYPE_TOOLBAR))
#define HRN_TOOLBAR_GET_CLASS(obj)                                      \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                              HRN_TYPE_TOOLBAR,                        \
                              HrnToolbarClass))

typedef struct _HrnToolbarPrivate HrnToolbarPrivate;
typedef struct _HrnToolbar HrnToolbar;
typedef struct _HrnToolbarClass HrnToolbarClass;

struct _HrnToolbar
{
  NbtkTable parent;

  HrnToolbarPrivate *priv;
};

struct _HrnToolbarClass
{
  NbtkTableClass parent_class;
};

GType       hrn_toolbar_get_type (void) G_GNUC_CONST;

NbtkWidget *hrn_toolbar_new             (HrnPinManager *pin_manager);
void        hrn_toolbar_focused         (HrnToolbar *toolbar);
void        hrn_toolbar_set_pinned      (HrnToolbar *toolbar,
                                         gboolean    pinned);
void        hrn_toolbar_set_filter_mode (HrnToolbar *toolbar,
                                         int         mode);
guint       hrn_toolbar_get_filter_mode (HrnToolbar *toolbar);
void        hrn_toolbar_set_query       (HrnToolbar *toolbar,
                                         const char *query);
const char *hrn_toolbar_get_query (HrnToolbar *toolbar);

void hrn_toolbar_set_zoom (HrnToolbar *toolbar,
                           double      zoom);
double hrn_toolbar_get_zoom (HrnToolbar *toolbar);

G_END_DECLS

#endif /* __HRN_TOOLBAR_H__ */
