/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __HRN_TEXTURE_FRAME_H__
#define __HRN_TEXTURE_FRAME_H__

#include <clutter/clutter.h>

G_BEGIN_DECLS

#define HRN_TYPE_TEXTURE_FRAME    (hrn_texture_frame_get_type ())

#define HRN_TEXTURE_FRAME(obj) \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_TEXTURE_FRAME, HrnTextureFrame))

#define HRN_TEXTURE_FRAME_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_TEXTURE_FRAME, HrnTextureFrameClass))
#define HRN_IS_TEXTURE_FRAME(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_TEXTURE_FRAME))

#define HRN_IS_TEXTURE_FRAME_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_TEXTURE_FRAME))

#define HRN_TEXTURE_FRAME_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_TEXTURE_FRAME, HrnTextureFrameClass))

typedef struct _HrnTextureFrame HrnTextureFrame;
typedef struct _HrnTextureFramePrivate HrnTextureFramePrivate;
typedef struct _HrnTextureFrameClass HrnTextureFrameClass;

struct _HrnTextureFrame
{
  /*< private >*/
  ClutterActor parent_instance;

  HrnTextureFramePrivate *priv;
};

struct _HrnTextureFrameClass
{
  ClutterActorClass parent_class;

  /* padding for future expansion */
  void (*_clutter_box_1)(void);
  void (*_clutter_box_2)(void);
  void (*_clutter_box_3)(void);
  void (*_clutter_box_4)(void);
};

GType           hrn_texture_frame_get_type (void) G_GNUC_CONST;
ClutterActor *  hrn_texture_frame_new                 (ClutterTexture *texture,
                                                       gfloat          top,
                                                       gfloat          right,
                                                       gfloat          bottom,
                                                       gfloat          left);
void            hrn_texture_frame_set_parent_texture  (HrnTextureFrame *frame,
                                                       ClutterTexture  *texture);
ClutterTexture *hrn_texture_frame_get_parent_texture  (HrnTextureFrame *frame);
void            hrn_texture_frame_set_frame           (HrnTextureFrame *frame,
                                                       gfloat           top,
                                                       gfloat           right,
                                                       gfloat           bottom,
                                                       gfloat           left);
void            hrn_texture_frame_get_frame           (HrnTextureFrame *frame,
                                                       gfloat          *top,
                                                       gfloat          *right,
                                                       gfloat          *bottom,
                                                       gfloat          *left);
void            hrn_texture_frame_set_draw_middle     (HrnTextureFrame *frame,
                                                       gboolean         value);
gboolean        hrn_texture_frame_get_scale_invariant (HrnTextureFrame *frame);
void            hrn_texture_frame_set_scale_invariant (HrnTextureFrame *frame,
                                                       gboolean         value);
void            hrn_texture_frame_set_can_pinch       (HrnTextureFrame *frame,
                                                       gboolean         value);

G_END_DECLS

#endif /* __HRN_TEXTURE_FRAME_H__ */
