#ifndef __HRN_PIN_MANAGER_H__
#define __HRN_PIN_MANAGER_H__

#include <glib-object.h>

#include "hrn-type.h"

G_BEGIN_DECLS

#define HRN_TYPE_PIN_MANAGER                                            \
   (hrn_pin_manager_get_type())
#define HRN_PIN_MANAGER(obj)                                            \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                HRN_TYPE_PIN_MANAGER,                   \
                                HrnPinManager))
#define HRN_PIN_MANAGER_CLASS(klass)                                    \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             HRN_TYPE_PIN_MANAGER,                      \
                             HrnPinManagerClass))
#define IS_HRN_PIN_MANAGER(obj)                                         \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                HRN_TYPE_PIN_MANAGER))
#define IS_HRN_PIN_MANAGER_CLASS(klass)                                 \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             HRN_TYPE_PIN_MANAGER))
#define HRN_PIN_MANAGER_GET_CLASS(obj)                                  \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               HRN_TYPE_PIN_MANAGER,                    \
                               HrnPinManagerClass))

typedef struct _HrnPinManagerPrivate HrnPinManagerPrivate;
typedef struct _HrnPinManager      HrnPinManager;
typedef struct _HrnPinManagerClass HrnPinManagerClass;
typedef struct _HrnPin HrnPin;

struct _HrnPin {
    char *group;
    char *name;
    char *query;
    char *source;
    int filter;
    HrnZoomLevel zoom_level;
};

struct _HrnPinManager
{
    GObject parent;

    HrnPinManagerPrivate *priv;
};

struct _HrnPinManagerClass
{
    GObjectClass parent_class;
};

GType hrn_pin_manager_get_type (void) G_GNUC_CONST;
HrnPinManager *hrn_pin_manager_new (const char *filename);

void hrn_pin_manager_write_to_file (HrnPinManager *manager,
                                    const char    *filename);

GList *hrn_pin_manager_get_pins (HrnPinManager *manager);
HrnPin *hrn_pin_manager_get_pin (HrnPinManager *manager,
                                 const char    *name);
void hrn_pin_manager_add (HrnPinManager *manager,
                          const char    *name,
                          const char    *query,
                          const char    *source,
                          int            filter,
                          HrnZoomLevel   zoom_level);
void hrn_pin_manager_remove (HrnPinManager *manager,
                             const char    *pin_group);
void hrn_pin_manager_rename_pin (HrnPinManager *manager,
                                 HrnPin        *pin,
                                 const char    *name);
void hrn_pin_manager_select_pin (HrnPinManager *manager,
                                 HrnPin        *pin);
const char *hrn_pin_manager_get_selected_pin (HrnPinManager *manager);

G_END_DECLS

#endif /* __HRN_PIN_MANAGER_H__ */
