// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Central application error code managment
// ****************************************************************************

#ifndef __MODULES_H__
#define __MODULES_H__

#define CREATE_MODULE_IDS(ModulName, x) \
   const int ERROR_BASE_ ## ModulName = ERROR_BASE_GUYMAGER_MAIN +  x * ID_OFFSET_SUBSUBPROJECT;


CREATE_MODULE_IDS (MAIN           ,  0)
CREATE_MODULE_IDS (LOG            ,  1)
CREATE_MODULE_IDS (CFG            ,  2)
CREATE_MODULE_IDS (UTIL           ,  3)
CREATE_MODULE_IDS (QTUTIL         ,  4)
CREATE_MODULE_IDS (SCAN           ,  5)
CREATE_MODULE_IDS (MAINWINDOW     ,  6)
CREATE_MODULE_IDS (TABLE          ,  7)
CREATE_MODULE_IDS (FIFO           ,  8)
CREATE_MODULE_IDS (THREADSCAN     ,  9)
CREATE_MODULE_IDS (THREADREAD     , 10)
CREATE_MODULE_IDS (THREADWRITE    , 11)
CREATE_MODULE_IDS (THREADHASH     , 12)
CREATE_MODULE_IDS (THREADCOMPRESS , 13)
CREATE_MODULE_IDS (DEVICE         , 14)
CREATE_MODULE_IDS (DEVICELISTMODEL, 15)
CREATE_MODULE_IDS (FILE           , 16)
CREATE_MODULE_IDS (ITEMDELEGATE   , 17)
CREATE_MODULE_IDS (INFO           , 18)
CREATE_MODULE_IDS (INFOFIELD      , 19)
CREATE_MODULE_IDS (DLGACQUIRE     , 20)
CREATE_MODULE_IDS (DLGMESSAGE     , 21)
CREATE_MODULE_IDS (DLGABORT       , 22)
CREATE_MODULE_IDS (DLGDIRSEL      , 23)
CREATE_MODULE_IDS (DLGWAIT        , 24)
CREATE_MODULE_IDS (HASH           , 25)
CREATE_MODULE_IDS (AAFF           , 26)

CREATE_MODULE_IDS (QT             , 99)

enum
{
   ERROR_QT_UNSUCCESSFUL = ERROR_BASE_QT + 1
};


#endif

