// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Information about the acquisition, creates the info file
// ****************************************************************************


#ifndef __INFO_H__
#define __INFO_H__



class t_InfoLocal;

class t_Info: public QObject
{
   public:
      t_Info (t_pcDevice pDevice=NULL);
     ~t_Info (void);

      void   SetDevice  (t_pcDevice pDevice);
      APIRET Create     (void);
      APIRET vWrite     (const char *pFormat, va_list pArguments);
      APIRET Write      (const char *pFormat, ...) __attribute__ ((format (printf, 2, 3))); // Non-static class functions have implicit this argument, thus we start counting the parameters for __attribute__ at 2, not 1 (see GNU C-Lib Function-Atttributes.html)
      APIRET Write      (const QString &Text);
      APIRET WriteLn    (const QString &Text=QString());
      APIRET Title      (const QString &Text);
      APIRET InitTable  (const QString &ColSep, const QString &ColSepReplace);
      APIRET AddRow     (const QString &Row);
      APIRET WriteTable (void);

      APIRET WriteDeviceInfo (void);

      static APIRET GetDeviceInfo (t_pcDevice pDevice, bool RichText, QString &Info);

   private:
      QString FullFileName (void);

   private:
      t_InfoLocal *pOwn;
};

typedef t_Info *t_pInfo;


// ------------------------------------
//             Error codes
// ------------------------------------

   #ifdef __MODULES_H__
      enum
      {
         ERROR_INFO_FILE_CREATE_FAILED  = ERROR_BASE_INFO + 1,
         ERROR_INFO_FILE_OPEN_FAILED,
         ERROR_INFO_FILE_WRITE_FAILED,
         ERROR_INFO_FILE_CLOSE_FAILED,
      };
   #endif

#endif

