//
// C++ Implementation: settingsdialog
//
// Description:
//
//
// Author: Lorn Potter <lorn.potter@gmail.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "settingsdialog.h"
#include "serverindex.h"
#include "gutendb.h"

#include <QFile>
#include <QTextStream>
#include <QFileInfo>
#include <QSettings>
#include <QTreeWidget>
#include <QTimer>
#include <QStringList>
#include <QList>

#include <QTreeWidgetItem>


settingsDialogBase::settingsDialogBase( QWidget *parent, Qt::WFlags f )
: QDialog(parent, f)
{
    setupUi( this );
 
}


settingsDialogBase::~settingsDialogBase()
{
}


settingsDialog::settingsDialog( QWidget *parent, Qt::WFlags f )
: settingsDialogBase(parent, f)
{
#ifdef Q_WS_QWS
    connect(settingsTreeWidget,SIGNAL(itemClicked(QTreeWidgetItem *,int)),
            this,SLOT(mirrorSelected(QTreeWidgetItem*,int)));
#else
    connect(settingsTreeWidget,SIGNAL(itemDoubleClicked(QTreeWidgetItem *,int)),
            this,SLOT(mirrorSelected(QTreeWidgetItem*,int)));
#endif
    connect(this,SIGNAL(accepted()),this,SLOT(doSelect()));

    QTimer::singleShot(500, this, SLOT(fillSettingsTree()));
}


settingsDialog::~settingsDialog()
{
}


void settingsDialog::newMirrorList()
{
    serverIndex *mirrorsFile;
    mirrorsFile = new serverIndex(); //parse mirrors list and insert to db
    mirrorsFile->parseServerFile();
 }


void settingsDialog::mirrorSelected( QTreeWidgetItem * item, int/* column*/ )
{
    QSettings settings("llornkcor", "Gutenbrowser");
    settings.setValue("network/server", item->text(2).simplified());
}


void settingsDialog::doSelect()
{
    mirrorSelected( settingsTreeWidget->currentItem(),0);
}


void settingsDialog::readSettings()
{
    QSettings settings("llornkcor", "Gutenbrowser");
    QString currentServer =  settings.value("network/server").toString();

    for(int i = 0; i < settingsTreeWidget->topLevelItemCount(); i++) {
        if(settingsTreeWidget->topLevelItem(i)->text(2) == currentServer)
            settingsTreeWidget->setCurrentItem(settingsTreeWidget->topLevelItem(i));
    }
}



void settingsDialog::fillSettingsTree()
{
    qApp->processEvents();
    // QApplication:: setOverrideCursor(Qt::WaitCursor);        
    qWarning("fillTree");
    QList<QStringList> list;

    gutenDb *gutdb;
    gutdb = new gutenDb();
    list = gutdb->returnServers();
    //  qWarning("settingsDialog::fillSettingsTree size of serverlist is %d",list.size());

  if(list.size() < 1) {
        newMirrorList();
        list = gutdb->returnServers();
    }
   qWarning("size of serverlist is now %d",list.size());

    QList<QTreeWidgetItem *> itemList;

    for (int i = 0; i < list.size(); ++i) {

        QTreeWidgetItem *item;
        item = new QTreeWidgetItem(settingsTreeWidget);

        QStringList strList = list[i];

        item->setText(0,strList.at(0));
        item->setText(1,strList.at(1));
        item->setText(2,strList.at(2));

        itemList << item;
    }

    settingsTreeWidget->addTopLevelItems(itemList);

    settingsTreeWidget->sortItems(0,Qt::AscendingOrder);
    settingsTreeWidget->resizeColumnToContents(1);

    readSettings();
    //    QApplication::restoreOverrideCursor();
}
