/****************************************************************************
**
** Copyright (C) 2000-$THISYEAR$ $TROLLTECH$. All rights reserved.
**
** This file is part of the $MODULE$ of the Qtopia Toolkit.
**
** $TROLLTECH_DUAL_LICENSE$
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef GUTEN_H
#define GUTEN_H

#ifdef Q_WS_QWS
#include "ui_gutenBase.h"
#else
#include "ui_gutenBase-desktop2.h"
#endif

class gutenDb;
class QFile;
class QStatusBar;
class QModelIndex;
class QSettings;
class QToolBar;

class GutenBase : public QMainWindow, public Ui_GutenBase
{
public:
    GutenBase( QWidget *parent = 0, Qt::WFlags f = 0 );
    virtual ~GutenBase();
protected:

};

class Guten : public GutenBase
{
    Q_OBJECT
public:
    Guten( QWidget *parent = 0, Qt::WFlags f = 0 );
    virtual ~Guten();
    
signals:
    void openSuccess();
    
protected slots:
    void showAll();
    void showMirrorSettings();
    void addFile();
    void addFiles();
    QSettings *getSettings();
    void readSettings();
    void writeSettings();
    void treePressed( const QModelIndex &);
    void lookupClicked();
    
private:
    QString preferredExtension;
    QAction *addFileAction;
    QAction *addFilesAction;
    QAction *removeAction;
    QAction *searchNetAction;
    QAction *showAllAction;
    QAction *showInstalledAction;
    QAction *backAction;
    QAction *forwardAction;
    
    QAction *pageDown;
    QAction *pageUp;
    
    QAction *aboutAct;
    QAction *aboutQtAct;
    
    void fetchEbook(const QString & ebook, int id);
    void fillTree(QList<QStringList>, bool installed = false );
    QStringList findFilesRecursively( QStringList paths, QStringList fileTypes );
    void createMenu();
    QString findFile(const QString &, const QString &);
    bool openEtext(const QString &);
    bool decompress(const QString& zipFile , const QString& outPath/*, const QString* */);
    void createToolbar();
    void createActions();
    void removeFile(const QString &str);
    QString findFileName(const QString &path, const QString &extension);


private slots:
    void about();
    void updateDb();
    void doSearch();
    void treeClicked(QTreeWidgetItem *,int);
    void treeClicked();
    void showInstalled();
    void doNewFont();
    void removeBook();
    void showSearchTab();
    void searchNet();
    void moveToTop();
    void moveToStart();
    void startAutoScroll();
    void loadStarted();
    void loadFinished(bool ok);
    void loadProgress(int progress);
    void timerScroll();
    void treeSelectionChanged();
    void showDatabaseWarning();
    void fetchEbookDone();
    void fetchEbookFailed();
    void openOk();
    
protected:
    QString gutenLibraryDir;
    gutenDb * gutdb;
    QStatusBar *status;
    int downloadId;
    void mousePressEvent(QMouseEvent * event );    
    void keyReleaseEvent(QKeyEvent * event );
};

#endif // GUTEN_H
