using GLib;
using GUPnP;

/*
 * TODO:
 *  * call setlocale
 *  * SIGTERM handler?
 */

public class Test.BrowsingTest : Object {

    public static int main (string[] args) {
        Context ctxt;

        try {
            ctxt = new Context (null, null, 0);
        } catch (Error err) {
            critical (err.message);
            return 1;
        }

        /* We're interested in everything */
        ControlPoint cp = new ControlPoint (ctxt, "ssdp:all");
        cp.device_proxy_available += on_device_proxy_available;
        cp.device_proxy_unavailable += on_device_proxy_unavailable;
        cp.service_proxy_available += on_service_proxy_available;
        cp.service_proxy_unavailable += on_service_proxy_unavailable;
        cp.active = true;

        MainLoop loop = new MainLoop (null, false);
        loop.run();

        return 0;
    }

    private static void on_service_proxy_available (ControlPoint cp,
                                                    ServiceProxy proxy) {
        print ("Service available:\n");
        print ("\ttype: %s\n", proxy.service_type);
        print ("\tlocation: %s\n", proxy.location);
    }

    private static void on_service_proxy_unavailable (ControlPoint cp,
                                                      ServiceProxy proxy) {
        print ("Service unavailable:\n");
        print ("\ttype: %s\n", proxy.service_type);
        print ("\tlocation: %s\n", proxy.location);
    }

    private static void on_device_proxy_available (ControlPoint cp,
                                                   DeviceProxy  proxy) {
        print ("Device available:\n");
        print ("\ttype: %s\n", proxy.device_type);
        print ("\tlocation: %s\n", proxy.location);
    }

    private static void on_device_proxy_unavailable (ControlPoint cp,
                                                     DeviceProxy  proxy) {
        print ("Device unavailable:\n");
        print ("\ttype: %s\n", proxy.device_type);
        print ("\tlocation: %s\n", proxy.location);
    }
}
