/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright © 2002-2014 Sylvain Rochet
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <gtk/gtk.h>

#include "global.h"

#include "display.h"
#include "callback.h"


void display_init()  {

	GtkWidget *vbox;
	GtkWidget *alignment;
	GtkWidget *label;
	GtkWidget *text;
	GtkTextBuffer *textbuff;
	GtkTextIter textiter;
	GtkWidget *scrolledwin;
	GtkWidget *buttonsbox;

	vbox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 15);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 15);
	g_object_set_data(G_OBJECT(currentgame->BoardCenter), "boardcenter", vbox);
	gtk_box_pack_start(GTK_BOX(currentgame->BoardCenter), vbox, TRUE, TRUE, 0);

	/* create title */
	alignment = gtk_alignment_new(0.5, 0.5, 1.0, 1.0);
	gtk_box_pack_start(GTK_BOX(vbox), alignment, FALSE, FALSE, 0);

	label = gtk_label_new(NULL);
	g_object_set_data(G_OBJECT(currentgame->BoardCenter), "boardcenter_title", label);
	gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
	gtk_container_add(GTK_CONTAINER(alignment), label);

	/* create text view */
	scrolledwin = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox), scrolledwin, TRUE, TRUE, 0);

	text = gtk_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(text), FALSE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(text), GTK_WRAP_WORD);
	textbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	gtk_text_buffer_get_end_iter(textbuff, &textiter);
	gtk_text_buffer_create_mark(textbuff, "endmark", &textiter, FALSE);
	g_object_set_data(G_OBJECT(currentgame->BoardCenter), "boardcenter_text", text);
	gtk_container_add(GTK_CONTAINER(scrolledwin), text);

	/* buttons box */
	buttonsbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 15);
	g_object_set_data(G_OBJECT(currentgame->BoardCenter), "boardcenter_buttons", buttonsbox);
	gtk_box_pack_start(GTK_BOX(vbox), buttonsbox, FALSE, FALSE, 0);

	gtk_widget_show_all(vbox);
	gtk_widget_hide(label);
	gtk_widget_hide(buttonsbox);
}


void display_hide()  {
	GtkWidget *vbox= g_object_get_data(G_OBJECT(currentgame->BoardCenter), "boardcenter");
	gtk_widget_hide(vbox);
}


void display_show()  {
	GtkWidget *vbox = g_object_get_data(G_OBJECT(currentgame->BoardCenter), "boardcenter");
	gtk_widget_show(vbox);
}


void display_clear_text() {
	GtkWidget *text;
	GtkTextBuffer *textbuff;
	GtkTextIter startiter, enditer;

	text = g_object_get_data(G_OBJECT(currentgame->BoardCenter), "boardcenter_text");
	textbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	gtk_text_buffer_get_bounds(textbuff, &startiter, &enditer);
	gtk_text_buffer_delete(textbuff, &startiter, &enditer);
}


void display_clear_buttons()  {
	GtkWidget *buttonsbox = g_object_get_data(G_OBJECT(currentgame->BoardCenter), "boardcenter_buttons");
	GList *list = gtk_container_get_children(GTK_CONTAINER(buttonsbox));
	for (list = g_list_first(list); list; list = g_list_next(list)) {
		gtk_widget_destroy(GTK_WIDGET(list->data));
	}
	g_list_free(list);
	gtk_widget_hide(buttonsbox);
}


void display_estate(gint32 estateid)  {
	GtkWidget *title = g_object_get_data(G_OBJECT(currentgame->BoardCenter), "boardcenter_title");

	if (estateid < 0) {
		gtk_widget_hide(title);
		return;
	}
	display_title(currentgame->estate[estateid].name);
}


void display_title(gchar *title) {
	GtkWidget *label;
	gchar *tmp;

	label = g_object_get_data(G_OBJECT(currentgame->BoardCenter), "boardcenter_title");
	tmp = g_markup_printf_escaped("<span size=\"xx-large\"><b>%s</b></span>", title);
	gtk_label_set_markup(GTK_LABEL(label), tmp);
	g_free(tmp);
	gtk_widget_show(label);
}


void display_text(gchar *message) {

	GtkWidget *text;
	GtkTextBuffer *textbuff;
	GtkTextIter textiter;

	text = g_object_get_data(G_OBJECT(currentgame->BoardCenter), "boardcenter_text");
	textbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	gtk_text_buffer_get_end_iter(textbuff, &textiter);
	if (gtk_text_iter_get_offset(&textiter)) {
		gtk_text_buffer_insert(textbuff, &textiter, "\n", 1);
	}
	gtk_text_buffer_insert(textbuff, &textiter, message, strlen(message));
}


void display_add_button(gchar *caption, gchar *command, gboolean enabled) {

	GtkWidget *buttonsbox;
	GtkWidget *button;
	gchar *text;

	buttonsbox = g_object_get_data(G_OBJECT(currentgame->BoardCenter), "boardcenter_buttons");

	/* build button */
	button = gtk_button_new_with_label(caption);
	gtk_box_pack_start(GTK_BOX(buttonsbox), button, TRUE, TRUE, 0);

	text = g_strdup_printf("%s\n", command );
	g_object_set_data_full(G_OBJECT(button), "command", text, g_free);
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(CallBack_button_command_pressed), NULL);
	gtk_widget_set_sensitive(button, enabled);

	gtk_widget_show_all(buttonsbox);
}
