/*
 * Copyright (c) 1998 Free Software Foundation
 * Copyright (c) 1996 Eric M. Ludlam
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 * 
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 * 
 * Please send bug reports, etc. to zappo@gnu.org.
 * 
 * $Log: doodle.h,v $
 * Revision 1.3  1998/09/22 13:33:35  zappo
 * Updated copyright, and nomenclaiture.
 *
 * Revision 1.2  1997/03/23 15:59:05  zappo
 * Standardized on eraser/dot size
 *
 * Revision 1.1  1996/03/17 15:22:52  zappo
 * Initial revision
 *
 * History:
 * zappo   3/8/96     Created
 */

#ifndef DOODLE_
#define DOODLE_ " Gtalk DOODLE v0.1 (c) 1996,8 Free Software Foundation"

/* Structures:: */
enum doodleToolType {
  NoTool = 0, Point, Scribble, Line, Rectangle, Elipse, Eraser,
  MAXTOOL
};

enum doodleColorType {
  NoColor = 0, White, Black, Red, Green, Blue, Orange, Yellow, Purple, 
  MAXCOLOR
};

struct Xcontext {
  Display             *display;		/* our display variable            */
  XtAppContext         app_context;	/* our application context         */
  GC                   gc;		/* graphic context to use          */
  GC                   black;		/* black graphic context to use    */
  GC                   white;		/* white graphic context to use    */
  GC                   xor;		/* XOR graphic context to use      */
  GC                   gcs[MAXCOLOR];	/* GCs to use in toolbox for doodls*/
  Widget               topLevel;	/* out toplevel shell widget       */
  Widget               topPane;	        /* top level pane width            */
  Widget               menuBox;		/* menu area                       */
  Widget               doodlePane;	/* pane where drawing happens      */
  Widget               toolBox;		/* place where tools boxes are     */
  Widget               drawToolBox;	/* place where tools are selected  */
  Widget               colorToolBox;	/* place where colors are selected */
  Widget               PixView;		/* place drawing is placed         */
  Pixmap               doodlePix;	/* pixmap backbuffer               */
  Widget               doodlePort;	/* viewport for our doodle         */
  Widget               doodleCanvas;	/* drawing canvas                  */
  enum doodleToolType  currentTool;	/* currently active tool           */
  enum doodleColorType currentColor;	/* currently active color          */
};

struct MenuItemConstructor {
  char           *button_name;
  char           *describe;
  XtCallbackProc  callback;
  XtPointer       data;
};

#define ABS(a) (((a)<0)?-(a):(a))
#define MIN(a,b) (((a)<(b))?(a):(b))
#define ERASERSIZE 20
#define DOTSIZE 6

/* Prototypes:: */
/* doodlenet.c */
extern void dnet_init(char *port, struct Xcontext *XCtxt);
extern void dnet_send_draw_command(char *tool, char *color, int numcoords, int x[], int y[]);
extern void dnet_read_sock(struct Xcontext *XCtxt, int *src, XtInputId *lxid);

/* doodle.c */
extern void X_expose_doodle(Widget w, struct Xcontext *XCtxt, XtPointer call_data);
extern void XW_build_radio_tools(Widget parent, struct Xcontext *XCtxt);
extern void X_make_menus(Widget parent);
extern void XW_build_radio_colors(Widget parent, struct Xcontext *XCtxt);

/* doodlecb.c */
extern char *tool_names[];
extern char *color_names[];
extern void X_mouse_doodle(Widget w, struct Xcontext *XCtxt, XEvent *e);
extern void X_toggle_cb(Widget w, struct Xcontext *XCtxt, XtPointer call_data);
extern void X_quit();
extern void X_color_cb(Widget w, struct Xcontext *XCtxt, XtPointer call_data);

#endif /* DOODLE_ */
