/*
  Gnome applet for Searching the web in a Practical, Outlined and Tidy way
  Copyright (C) 2007 Norberto M. Lopes shelika@mail.telepac.pt
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   
  
  @author: Norberto M. Lopes shelika@mail.telepac.pt
*/
#include <string.h>

#include <panel-applet.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkimage.h>
#include <gtk/gtktooltips.h>
#include <gtk/gtkbutton.h>

#include "gspot_engines.h"
#include "gspot_callbacks.h"

/* Popup menu on the applet */
static const BonoboUIVerb gspot_applet_menu_verbs[] = {
  BONOBO_UI_UNSAFE_VERB ("about", menu_about_cb),
  BONOBO_UI_VERB_END
};

static gboolean gspot_applet_fill(PanelApplet *applet) {
  gspotData *gspot;
  
  gspot = g_new0(gspotData, 1);

  gspot->size = 0;
  gspot->menu = NULL;

  gspot->frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(gspot->frame), GTK_SHADOW_NONE);
  panel_applet_set_flags (applet, PANEL_APPLET_EXPAND_MINOR);
  gtk_container_add(GTK_CONTAINER(applet), gspot->frame);
    
  gspot->image = gtk_image_new();
  gtk_container_add(GTK_CONTAINER(gspot->frame), gspot->image);
  gspot->applet = GTK_WIDGET(applet);
  
  gspot->tooltips = gtk_tooltips_new();
  gtk_tooltips_set_tip( gspot->tooltips, GTK_WIDGET(applet), _("Gspot: Query the Net"), NULL);
  
  gspot_applet_build_menu(gspot);
  
    /* here */ g_signal_connect(gspot->applet, "change_background", G_CALLBACK(applet_change_background_cb), gspot);
  g_signal_connect(gspot->applet, "button_press_event", G_CALLBACK(button_press_callback), gspot);
  g_signal_connect(gspot->applet, "change_size", G_CALLBACK(applet_change_size_cb), gspot );
  panel_applet_setup_menu_from_file(PANEL_APPLET(applet), NULL, "GNOME_gspotApplet.xml", NULL, gspot_applet_menu_verbs, gspot);
  
  applet_change_size_cb ( applet, panel_applet_get_size(applet), gspot );
  gtk_widget_show_all(GTK_WIDGET(applet));
  return TRUE;
}

static gboolean gspot_applet_factory(PanelApplet *applet, const gchar *iid, gpointer data) {

  gboolean retval = FALSE;
  
  if( !strcmp( iid, "OAFIID:GNOME_gspotApplet" ) )
    retval = gspot_applet_fill( applet );
  
  return retval;
}

PANEL_APPLET_BONOBO_FACTORY( "OAFIID:GNOME_gspotApplet_Factory",
			     PANEL_TYPE_APPLET,
			     "gspot",
			     "0",
			     gspot_applet_factory,
			     NULL )
