// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/cloud/speech/v1/cloud_speech.proto
// DO NOT EDIT!

/*
Package google_cloud_speech_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/cloud/speech/v1/cloud_speech.proto

It has these top-level messages:
	RecognizeRequest
	InitialRecognizeRequest
	SpeechContext
	AudioRequest
	NonStreamingRecognizeResponse
	RecognizeResponse
	SpeechRecognitionResult
	SpeechRecognitionAlternative
*/
package google_cloud_speech_v1 // import "google.golang.org/genproto/googleapis/cloud/speech/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Audio encoding of the data sent in the audio message. All encodings support
// only 1 channel (mono) audio. Only `FLAC` includes a header that describes
// the bytes of audio that follow the header. The other encodings are raw
// audio bytes with no header.
//
// For best results, the audio source should be captured and transmitted using
// a lossless encoding (`FLAC` or `LINEAR16`). Recognition accuracy may be
// reduced if lossy codecs (such as AMR, AMR_WB and MULAW) are used to capture
// or transmit the audio, particularly if background noise is present.
type InitialRecognizeRequest_AudioEncoding int32

const (
	// Not specified. Will return result [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
	InitialRecognizeRequest_ENCODING_UNSPECIFIED InitialRecognizeRequest_AudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples.
	InitialRecognizeRequest_LINEAR16 InitialRecognizeRequest_AudioEncoding = 1
	// This is the recommended encoding because it uses lossless compression;
	// therefore recognition accuracy is not compromised by a lossy codec.
	//
	// The stream FLAC (Free Lossless Audio Codec) encoding is specified at:
	// http://flac.sourceforge.net/documentation.html.
	// Only 16-bit samples are supported.
	// Not all fields in STREAMINFO are supported.
	InitialRecognizeRequest_FLAC InitialRecognizeRequest_AudioEncoding = 2
	// 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
	InitialRecognizeRequest_MULAW InitialRecognizeRequest_AudioEncoding = 3
	// Adaptive Multi-Rate Narrowband codec. `sample_rate` must be 8000 Hz.
	InitialRecognizeRequest_AMR InitialRecognizeRequest_AudioEncoding = 4
	// Adaptive Multi-Rate Wideband codec. `sample_rate` must be 16000 Hz.
	InitialRecognizeRequest_AMR_WB InitialRecognizeRequest_AudioEncoding = 5
)

var InitialRecognizeRequest_AudioEncoding_name = map[int32]string{
	0: "ENCODING_UNSPECIFIED",
	1: "LINEAR16",
	2: "FLAC",
	3: "MULAW",
	4: "AMR",
	5: "AMR_WB",
}
var InitialRecognizeRequest_AudioEncoding_value = map[string]int32{
	"ENCODING_UNSPECIFIED": 0,
	"LINEAR16":             1,
	"FLAC":                 2,
	"MULAW":                3,
	"AMR":                  4,
	"AMR_WB":               5,
}

func (x InitialRecognizeRequest_AudioEncoding) String() string {
	return proto.EnumName(InitialRecognizeRequest_AudioEncoding_name, int32(x))
}
func (InitialRecognizeRequest_AudioEncoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{1, 0}
}

// Indicates the type of endpointer event.
type RecognizeResponse_EndpointerEvent int32

const (
	// No endpointer event specified.
	RecognizeResponse_ENDPOINTER_EVENT_UNSPECIFIED RecognizeResponse_EndpointerEvent = 0
	// Speech has been detected in the audio stream.
	RecognizeResponse_START_OF_SPEECH RecognizeResponse_EndpointerEvent = 1
	// Speech has ceased to be detected in the audio stream.
	RecognizeResponse_END_OF_SPEECH RecognizeResponse_EndpointerEvent = 2
	// The end of the audio stream has been reached. and it is being processed.
	RecognizeResponse_END_OF_AUDIO RecognizeResponse_EndpointerEvent = 3
	// This event is only sent when continuous is `false`. It indicates that the
	// server has detected the end of the user's speech utterance and expects no
	// additional speech. Therefore, the server will not process additional
	// audio. The client should stop sending additional audio data.
	RecognizeResponse_END_OF_UTTERANCE RecognizeResponse_EndpointerEvent = 4
)

var RecognizeResponse_EndpointerEvent_name = map[int32]string{
	0: "ENDPOINTER_EVENT_UNSPECIFIED",
	1: "START_OF_SPEECH",
	2: "END_OF_SPEECH",
	3: "END_OF_AUDIO",
	4: "END_OF_UTTERANCE",
}
var RecognizeResponse_EndpointerEvent_value = map[string]int32{
	"ENDPOINTER_EVENT_UNSPECIFIED": 0,
	"START_OF_SPEECH":              1,
	"END_OF_SPEECH":                2,
	"END_OF_AUDIO":                 3,
	"END_OF_UTTERANCE":             4,
}

func (x RecognizeResponse_EndpointerEvent) String() string {
	return proto.EnumName(RecognizeResponse_EndpointerEvent_name, int32(x))
}
func (RecognizeResponse_EndpointerEvent) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{5, 0}
}

// `RecognizeRequest` is the only message type sent by the client.
//
// When using the REST API or the gRPC `NonStreamingRecognize` API, only one
// `RecognizeRequest` message is sent, and it must contain both an
// `initial_request` and an 'audio_request`.
//
// When using the gRPC Streaming `Recognize` API, one or more `RecognizeRequest`
// messages are sent. The first message must contain an `initial_request` and
// may contain an 'audio_request`. Any subsequent messages must not contain an
// `initial_request` and must contain an 'audio_request`.
type RecognizeRequest struct {
	// The `initial_request` message provides information to the recognizer
	// that specifies how to process the request.
	//
	// The first `RecognizeRequest` message must contain an `initial_request`.
	// Any subsequent `RecognizeRequest` messages must not contain an
	// `initial_request`.
	InitialRequest *InitialRecognizeRequest `protobuf:"bytes,1,opt,name=initial_request,json=initialRequest" json:"initial_request,omitempty"`
	// The audio data to be recognized. For REST or `NonStreamingRecognize`, all
	// audio data must be contained in the first (and only) `RecognizeRequest`
	// message. For gRPC streaming `Recognize`, sequential chunks of audio data
	// are sent in sequential `RecognizeRequest` messages.
	AudioRequest *AudioRequest `protobuf:"bytes,2,opt,name=audio_request,json=audioRequest" json:"audio_request,omitempty"`
}

func (m *RecognizeRequest) Reset()                    { *m = RecognizeRequest{} }
func (m *RecognizeRequest) String() string            { return proto.CompactTextString(m) }
func (*RecognizeRequest) ProtoMessage()               {}
func (*RecognizeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *RecognizeRequest) GetInitialRequest() *InitialRecognizeRequest {
	if m != nil {
		return m.InitialRequest
	}
	return nil
}

func (m *RecognizeRequest) GetAudioRequest() *AudioRequest {
	if m != nil {
		return m.AudioRequest
	}
	return nil
}

// The `InitialRecognizeRequest` message provides information to the recognizer
// that specifies how to process the request.
type InitialRecognizeRequest struct {
	// [Required] Encoding of audio data sent in all `AudioRequest` messages.
	Encoding InitialRecognizeRequest_AudioEncoding `protobuf:"varint,1,opt,name=encoding,enum=google.cloud.speech.v1.InitialRecognizeRequest_AudioEncoding" json:"encoding,omitempty"`
	// [Required] Sample rate in Hertz of the audio data sent in all
	// AudioRequest messages. Valid values are: 8000-48000.
	// 16000 is optimal. For best results, set the sampling rate of the audio
	// source to 16000 Hz. If that's not possible, use the native sample rate of
	// the audio source (instead of re-sampling).
	SampleRate int32 `protobuf:"varint,2,opt,name=sample_rate,json=sampleRate" json:"sample_rate,omitempty"`
	// [Optional] The language of the supplied audio as a BCP-47 language tag.
	// Example: "en-GB"  https://www.rfc-editor.org/rfc/bcp/bcp47.txt
	// If omitted, defaults to "en-US". See
	// [Language Support](/speech/docs/best-practices#language_support) for
	// a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
	// [Optional] Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechRecognitionResult`.
	// The server may return fewer than `max_alternatives`.
	// Valid values are `0`-`30`. A value of `0` or `1` will return a maximum of
	// `1`. If omitted, defaults to `1`.
	MaxAlternatives int32 `protobuf:"varint,4,opt,name=max_alternatives,json=maxAlternatives" json:"max_alternatives,omitempty"`
	// [Optional] If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	ProfanityFilter bool `protobuf:"varint,5,opt,name=profanity_filter,json=profanityFilter" json:"profanity_filter,omitempty"`
	// [Optional] If `false` or omitted, the recognizer will detect a single
	// spoken utterance, and it will cease recognition when the user stops
	// speaking. If `enable_endpointer_events` is `true`, it will return
	// `END_OF_UTTERANCE` when it detects that the user has stopped speaking.
	// In all cases, it will return no more than one `SpeechRecognitionResult`,
	// and set the `is_final` flag to `true`.
	//
	// If `true`, the recognizer will continue recognition (even if the user
	// pauses speaking) until the client closes the output stream (gRPC API) or
	// completes the POST data (REST API) or when the maximum time limit has been
	// reached. Multiple `SpeechRecognitionResult`s with the `is_final` flag set
	// to `true` may be returned to indicate that the recognizer will not return
	// any further hypotheses for that portion of the transcript.
	Continuous bool `protobuf:"varint,6,opt,name=continuous" json:"continuous,omitempty"`
	// [Optional] If this parameter is `true`, interim results may be returned as
	// they become available.
	// If `false` or omitted, only `is_final=true` result(s) are returned.
	InterimResults bool `protobuf:"varint,7,opt,name=interim_results,json=interimResults" json:"interim_results,omitempty"`
	// [Optional] If this parameter is `true`, `EndpointerEvents` may be returned
	// as they become available.
	// If `false` or omitted, no `EndpointerEvents` are returned.
	EnableEndpointerEvents bool `protobuf:"varint,8,opt,name=enable_endpointer_events,json=enableEndpointerEvents" json:"enable_endpointer_events,omitempty"`
	// [Optional] URI that points to a file where the recognition result should
	// be stored in JSON format. If omitted or empty string, the recognition
	// result is returned in the response. Should be specified only for
	// `NonStreamingRecognize`. If specified in a `Recognize` request,
	// `Recognize` returns [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
	// If specified in a `NonStreamingRecognize` request,
	// `NonStreamingRecognize` returns immediately, and the output file
	// is created asynchronously once the audio processing completes.
	// Currently, only Google Cloud Storage URIs are supported, which must be
	// specified in the following format: `gs://bucket_name/object_name`
	// (other URI formats return [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,9,opt,name=output_uri,json=outputUri" json:"output_uri,omitempty"`
	// [Optional] A means to provide context to assist the speech recognition.
	SpeechContext *SpeechContext `protobuf:"bytes,10,opt,name=speech_context,json=speechContext" json:"speech_context,omitempty"`
}

func (m *InitialRecognizeRequest) Reset()                    { *m = InitialRecognizeRequest{} }
func (m *InitialRecognizeRequest) String() string            { return proto.CompactTextString(m) }
func (*InitialRecognizeRequest) ProtoMessage()               {}
func (*InitialRecognizeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *InitialRecognizeRequest) GetSpeechContext() *SpeechContext {
	if m != nil {
		return m.SpeechContext
	}
	return nil
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	// [Optional] A list of up to 50 phrases of up to 100 characters each to
	// provide words and phrases "hints" to the speech recognition so that it is
	// more likely to recognize them.
	Phrases []string `protobuf:"bytes,1,rep,name=phrases" json:"phrases,omitempty"`
}

func (m *SpeechContext) Reset()                    { *m = SpeechContext{} }
func (m *SpeechContext) String() string            { return proto.CompactTextString(m) }
func (*SpeechContext) ProtoMessage()               {}
func (*SpeechContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Contains audio data in the encoding specified in the
// `InitialRecognizeRequest`. Either `content` or `uri` must be supplied.
// Supplying both or neither returns [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
type AudioRequest struct {
	// The audio data bytes encoded as specified in
	// `InitialRecognizeRequest`. Note: as with all bytes fields, protobuffers
	// use a pure binary representation, whereas JSON representations use base64.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// URI that points to a file that contains audio data bytes as specified in
	// `InitialRecognizeRequest`. Currently, only Google Cloud Storage URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket_name/object_name` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](/storage/docs/reference-uris).
	Uri string `protobuf:"bytes,2,opt,name=uri" json:"uri,omitempty"`
}

func (m *AudioRequest) Reset()                    { *m = AudioRequest{} }
func (m *AudioRequest) String() string            { return proto.CompactTextString(m) }
func (*AudioRequest) ProtoMessage()               {}
func (*AudioRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// `NonStreamingRecognizeResponse` is the only message returned to the client by
// `NonStreamingRecognize`. It contains the result as zero or more sequential
// `RecognizeResponse` messages.
//
// Note that streaming `Recognize` will also return multiple `RecognizeResponse`
// messages, but each message is individually streamed.
type NonStreamingRecognizeResponse struct {
	// [Output-only] Sequential list of messages returned by the recognizer.
	Responses []*RecognizeResponse `protobuf:"bytes,1,rep,name=responses" json:"responses,omitempty"`
}

func (m *NonStreamingRecognizeResponse) Reset()                    { *m = NonStreamingRecognizeResponse{} }
func (m *NonStreamingRecognizeResponse) String() string            { return proto.CompactTextString(m) }
func (*NonStreamingRecognizeResponse) ProtoMessage()               {}
func (*NonStreamingRecognizeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *NonStreamingRecognizeResponse) GetResponses() []*RecognizeResponse {
	if m != nil {
		return m.Responses
	}
	return nil
}

// `RecognizeResponse` is the only message type returned to the client.
type RecognizeResponse struct {
	// [Output-only] If set, returns a [google.rpc.Status][] message that
	// specifies the error for the operation.
	Error *google_rpc.Status `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// [Output-only] For `continuous=false`, this repeated list contains zero or
	// one result that corresponds to all of the audio processed so far. For
	// `continuous=true`, this repeated list contains zero or more results that
	// correspond to consecutive portions of the audio being processed.
	// In both cases, contains zero or one `is_final=true` result (the newly
	// settled portion), followed by zero or more `is_final=false` results.
	Results []*SpeechRecognitionResult `protobuf:"bytes,2,rep,name=results" json:"results,omitempty"`
	// [Output-only] Indicates the lowest index in the `results` array that has
	// changed. The repeated `SpeechRecognitionResult` results overwrite past
	// results at this index and higher.
	ResultIndex int32 `protobuf:"varint,3,opt,name=result_index,json=resultIndex" json:"result_index,omitempty"`
	// [Output-only] Indicates the type of endpointer event.
	Endpoint RecognizeResponse_EndpointerEvent `protobuf:"varint,4,opt,name=endpoint,enum=google.cloud.speech.v1.RecognizeResponse_EndpointerEvent" json:"endpoint,omitempty"`
}

func (m *RecognizeResponse) Reset()                    { *m = RecognizeResponse{} }
func (m *RecognizeResponse) String() string            { return proto.CompactTextString(m) }
func (*RecognizeResponse) ProtoMessage()               {}
func (*RecognizeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *RecognizeResponse) GetError() *google_rpc.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *RecognizeResponse) GetResults() []*SpeechRecognitionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechRecognitionResult struct {
	// [Output-only] May contain one or more recognition hypotheses (up to the
	// maximum specified in `max_alternatives`).
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives" json:"alternatives,omitempty"`
	// [Output-only] Set `true` if this is the final time the speech service will
	// return this particular `SpeechRecognitionResult`. If `false`, this
	// represents an interim result that may change.
	IsFinal bool `protobuf:"varint,2,opt,name=is_final,json=isFinal" json:"is_final,omitempty"`
	// [Output-only] An estimate of the probability that the recognizer will not
	// change its guess about this interim result. Values range from 0.0
	// (completely unstable) to 1.0 (completely stable). Note that this is not the
	// same as `confidence`, which estimates the probability that a recognition
	// result is correct.
	// This field is only provided for interim results (`is_final=false`).
	// The default of 0.0 is a sentinel value indicating stability was not set.
	Stability float32 `protobuf:"fixed32,3,opt,name=stability" json:"stability,omitempty"`
}

func (m *SpeechRecognitionResult) Reset()                    { *m = SpeechRecognitionResult{} }
func (m *SpeechRecognitionResult) String() string            { return proto.CompactTextString(m) }
func (*SpeechRecognitionResult) ProtoMessage()               {}
func (*SpeechRecognitionResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *SpeechRecognitionResult) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	// [Output-only] Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript" json:"transcript,omitempty"`
	// [Output-only] The confidence estimate between 0.0 and 1.0. A higher number
	// means the system is more confident that the recognition is correct.
	// This field is typically provided only for the top hypothesis. and only for
	// `is_final=true` results.
	// The default of 0.0 is a sentinel value indicating confidence was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence" json:"confidence,omitempty"`
}

func (m *SpeechRecognitionAlternative) Reset()                    { *m = SpeechRecognitionAlternative{} }
func (m *SpeechRecognitionAlternative) String() string            { return proto.CompactTextString(m) }
func (*SpeechRecognitionAlternative) ProtoMessage()               {}
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func init() {
	proto.RegisterType((*RecognizeRequest)(nil), "google.cloud.speech.v1.RecognizeRequest")
	proto.RegisterType((*InitialRecognizeRequest)(nil), "google.cloud.speech.v1.InitialRecognizeRequest")
	proto.RegisterType((*SpeechContext)(nil), "google.cloud.speech.v1.SpeechContext")
	proto.RegisterType((*AudioRequest)(nil), "google.cloud.speech.v1.AudioRequest")
	proto.RegisterType((*NonStreamingRecognizeResponse)(nil), "google.cloud.speech.v1.NonStreamingRecognizeResponse")
	proto.RegisterType((*RecognizeResponse)(nil), "google.cloud.speech.v1.RecognizeResponse")
	proto.RegisterType((*SpeechRecognitionResult)(nil), "google.cloud.speech.v1.SpeechRecognitionResult")
	proto.RegisterType((*SpeechRecognitionAlternative)(nil), "google.cloud.speech.v1.SpeechRecognitionAlternative")
	proto.RegisterEnum("google.cloud.speech.v1.InitialRecognizeRequest_AudioEncoding", InitialRecognizeRequest_AudioEncoding_name, InitialRecognizeRequest_AudioEncoding_value)
	proto.RegisterEnum("google.cloud.speech.v1.RecognizeResponse_EndpointerEvent", RecognizeResponse_EndpointerEvent_name, RecognizeResponse_EndpointerEvent_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Speech service

type SpeechClient interface {
	// Perform bidirectional streaming speech-recognition: receive results while
	// sending audio.
	Recognize(ctx context.Context, opts ...grpc.CallOption) (Speech_RecognizeClient, error)
	// Perform non-streaming speech-recognition: receive results after all audio
	// has been sent and processed.
	NonStreamingRecognize(ctx context.Context, in *RecognizeRequest, opts ...grpc.CallOption) (*NonStreamingRecognizeResponse, error)
}

type speechClient struct {
	cc *grpc.ClientConn
}

func NewSpeechClient(cc *grpc.ClientConn) SpeechClient {
	return &speechClient{cc}
}

func (c *speechClient) Recognize(ctx context.Context, opts ...grpc.CallOption) (Speech_RecognizeClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Speech_serviceDesc.Streams[0], c.cc, "/google.cloud.speech.v1.Speech/Recognize", opts...)
	if err != nil {
		return nil, err
	}
	x := &speechRecognizeClient{stream}
	return x, nil
}

type Speech_RecognizeClient interface {
	Send(*RecognizeRequest) error
	Recv() (*RecognizeResponse, error)
	grpc.ClientStream
}

type speechRecognizeClient struct {
	grpc.ClientStream
}

func (x *speechRecognizeClient) Send(m *RecognizeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *speechRecognizeClient) Recv() (*RecognizeResponse, error) {
	m := new(RecognizeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *speechClient) NonStreamingRecognize(ctx context.Context, in *RecognizeRequest, opts ...grpc.CallOption) (*NonStreamingRecognizeResponse, error) {
	out := new(NonStreamingRecognizeResponse)
	err := grpc.Invoke(ctx, "/google.cloud.speech.v1.Speech/NonStreamingRecognize", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Speech service

type SpeechServer interface {
	// Perform bidirectional streaming speech-recognition: receive results while
	// sending audio.
	Recognize(Speech_RecognizeServer) error
	// Perform non-streaming speech-recognition: receive results after all audio
	// has been sent and processed.
	NonStreamingRecognize(context.Context, *RecognizeRequest) (*NonStreamingRecognizeResponse, error)
}

func RegisterSpeechServer(s *grpc.Server, srv SpeechServer) {
	s.RegisterService(&_Speech_serviceDesc, srv)
}

func _Speech_Recognize_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SpeechServer).Recognize(&speechRecognizeServer{stream})
}

type Speech_RecognizeServer interface {
	Send(*RecognizeResponse) error
	Recv() (*RecognizeRequest, error)
	grpc.ServerStream
}

type speechRecognizeServer struct {
	grpc.ServerStream
}

func (x *speechRecognizeServer) Send(m *RecognizeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *speechRecognizeServer) Recv() (*RecognizeRequest, error) {
	m := new(RecognizeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Speech_NonStreamingRecognize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecognizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).NonStreamingRecognize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Speech/NonStreamingRecognize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).NonStreamingRecognize(ctx, req.(*RecognizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Speech_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.speech.v1.Speech",
	HandlerType: (*SpeechServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "NonStreamingRecognize",
			Handler:    _Speech_NonStreamingRecognize_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Recognize",
			Handler:       _Speech_Recognize_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google.golang.org/genproto/googleapis/cloud/speech/v1/cloud_speech.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/cloud/speech/v1/cloud_speech.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 989 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x56, 0xdd, 0x6e, 0x1b, 0xc5,
	0x17, 0xff, 0xaf, 0x1d, 0x27, 0xf6, 0x89, 0x9d, 0x6c, 0xe7, 0x1f, 0xda, 0x6d, 0x94, 0xd2, 0xb0,
	0x80, 0x70, 0x40, 0xb2, 0x49, 0xf8, 0x10, 0x44, 0xea, 0x85, 0xe3, 0x6c, 0xda, 0x95, 0x12, 0x27,
	0x1a, 0xdb, 0xb4, 0xdc, 0xb0, 0x9a, 0xac, 0x27, 0xce, 0x48, 0xf6, 0xcc, 0x32, 0x33, 0x1b, 0xa5,
	0x5c, 0xc2, 0x0d, 0xe2, 0x96, 0x2b, 0xde, 0x81, 0x7b, 0x1e, 0x84, 0x47, 0x80, 0x07, 0x41, 0x3b,
	0xb3, 0x76, 0x9c, 0xb4, 0x8e, 0xdc, 0x2b, 0xcf, 0xf9, 0x9d, 0x33, 0xbf, 0x73, 0xe6, 0x7c, 0xad,
	0xe1, 0xc5, 0x50, 0x88, 0xe1, 0x88, 0x36, 0x86, 0x62, 0x44, 0xf8, 0xb0, 0x21, 0xe4, 0xb0, 0x39,
	0xa4, 0x3c, 0x91, 0x42, 0x8b, 0xa6, 0x55, 0x91, 0x84, 0xa9, 0x66, 0x3c, 0x12, 0xe9, 0xa0, 0xa9,
	0x12, 0x4a, 0xe3, 0xcb, 0xe6, 0xd5, 0xae, 0x95, 0x23, 0x2b, 0x37, 0x8c, 0x35, 0x7a, 0x98, 0x33,
	0x19, 0x55, 0x23, 0x57, 0x5d, 0xed, 0x6e, 0x86, 0x8b, 0x79, 0x20, 0x09, 0x6b, 0x2a, 0x2a, 0xaf,
	0x58, 0x4c, 0x63, 0xc1, 0x2f, 0xd8, 0xb0, 0x49, 0x38, 0x17, 0x9a, 0x68, 0x26, 0xb8, 0xb2, 0x2e,
	0x36, 0x9f, 0x2d, 0x46, 0x25, 0x93, 0xb8, 0xa9, 0x34, 0xd1, 0xa9, 0xca, 0x7f, 0xec, 0x75, 0xff,
	0x2f, 0x07, 0x5c, 0x4c, 0x63, 0x31, 0xe4, 0xec, 0x27, 0x8a, 0xe9, 0x8f, 0x29, 0x55, 0x1a, 0xbd,
	0x82, 0x75, 0xc6, 0x99, 0x66, 0x64, 0x14, 0x49, 0x0b, 0x79, 0xce, 0xb6, 0x53, 0x5f, 0xdd, 0x6b,
	0x36, 0xde, 0xfe, 0xa0, 0x46, 0x68, 0xcd, 0xef, 0x32, 0xe1, 0x35, 0x36, 0x51, 0x58, 0xe6, 0x10,
	0x6a, 0x24, 0x1d, 0x30, 0x31, 0xe5, 0x2d, 0x18, 0xde, 0x8f, 0xe6, 0xf1, 0xb6, 0x32, 0xe3, 0x09,
	0x59, 0x95, 0xcc, 0x48, 0xfe, 0x3f, 0x4b, 0xf0, 0x68, 0x8e, 0x5b, 0xf4, 0x3d, 0x94, 0x29, 0x8f,
	0xc5, 0x80, 0xf1, 0xa1, 0x89, 0x7c, 0x6d, 0xef, 0xd9, 0x3b, 0x46, 0x6e, 0x3d, 0x07, 0x39, 0x09,
	0x9e, 0xd2, 0xa1, 0xa7, 0xb0, 0xaa, 0xc8, 0x38, 0x19, 0xd1, 0x48, 0x12, 0x4d, 0x4d, 0xfc, 0x25,
	0x0c, 0x16, 0xc2, 0x44, 0x53, 0xf4, 0x21, 0xd4, 0xb2, 0x4a, 0xa4, 0x64, 0x48, 0xa3, 0x58, 0x0c,
	0xa8, 0x57, 0xdc, 0x76, 0xea, 0x15, 0x5c, 0x9d, 0x80, 0x6d, 0x31, 0xa0, 0x68, 0x07, 0xdc, 0x31,
	0xb9, 0x8e, 0xc8, 0x48, 0x53, 0xc9, 0x89, 0x66, 0x57, 0x54, 0x79, 0x4b, 0x86, 0x6a, 0x7d, 0x4c,
	0xae, 0x5b, 0x33, 0x70, 0x66, 0x9a, 0x48, 0x71, 0x41, 0x38, 0xd3, 0xaf, 0xa3, 0x0b, 0x96, 0xa9,
	0xbc, 0xd2, 0xb6, 0x53, 0x2f, 0xe3, 0xf5, 0x29, 0x7e, 0x64, 0x60, 0xf4, 0x3e, 0x40, 0x2c, 0xb8,
	0x66, 0x3c, 0x15, 0xa9, 0xf2, 0x96, 0x8d, 0xd1, 0x0c, 0x82, 0x3e, 0xc9, 0xea, 0xaa, 0xa9, 0x64,
	0xe3, 0x48, 0x52, 0x95, 0x8e, 0xb4, 0xf2, 0x56, 0x8c, 0xd1, 0x5a, 0x0e, 0x63, 0x8b, 0xa2, 0x6f,
	0xc0, 0xa3, 0x9c, 0x9c, 0x8f, 0x68, 0x44, 0xf9, 0x20, 0x11, 0x46, 0x1b, 0xd1, 0x2b, 0xca, 0xb5,
	0xf2, 0xca, 0xe6, 0xc6, 0x43, 0xab, 0x0f, 0xa6, 0xea, 0xc0, 0x68, 0xd1, 0x13, 0x00, 0x91, 0xea,
	0x24, 0xd5, 0x51, 0x2a, 0x99, 0x57, 0x31, 0x4f, 0xaf, 0x58, 0xa4, 0x2f, 0x19, 0x3a, 0x86, 0x35,
	0x9b, 0xfa, 0x28, 0x0b, 0x8b, 0x5e, 0x6b, 0x0f, 0x4c, 0x03, 0x7c, 0x3c, 0xaf, 0x3c, 0x5d, 0x73,
	0x6a, 0x5b, 0x63, 0x5c, 0x53, 0xb3, 0xa2, 0x4f, 0xa0, 0x76, 0xab, 0x4c, 0xc8, 0x83, 0x8d, 0xa0,
	0xd3, 0x3e, 0x3d, 0x0c, 0x3b, 0xcf, 0xa3, 0x7e, 0xa7, 0x7b, 0x16, 0xb4, 0xc3, 0xa3, 0x30, 0x38,
	0x74, 0xff, 0x87, 0xaa, 0x50, 0x3e, 0x0e, 0x3b, 0x41, 0x0b, 0xef, 0x7e, 0xed, 0x3a, 0xa8, 0x0c,
	0x4b, 0x47, 0xc7, 0xad, 0xb6, 0x5b, 0x40, 0x15, 0x28, 0x9d, 0xf4, 0x8f, 0x5b, 0x2f, 0xdd, 0x22,
	0x5a, 0x81, 0x62, 0xeb, 0x04, 0xbb, 0x4b, 0x08, 0x60, 0xb9, 0x75, 0x82, 0xa3, 0x97, 0x07, 0x6e,
	0xc9, 0xdf, 0x81, 0xda, 0xad, 0x10, 0x90, 0x07, 0x2b, 0xc9, 0xa5, 0x24, 0x8a, 0x2a, 0xcf, 0xd9,
	0x2e, 0xd6, 0x2b, 0x78, 0x22, 0xfa, 0xfb, 0x50, 0x9d, 0x6d, 0xd7, 0xcc, 0xd2, 0x3c, 0x92, 0xdb,
	0xe9, 0xa9, 0xe2, 0x89, 0x88, 0x5c, 0x28, 0x66, 0xd9, 0x29, 0x98, 0xec, 0x64, 0x47, 0xff, 0x12,
	0x9e, 0x74, 0x04, 0xef, 0x6a, 0x49, 0xc9, 0x38, 0xeb, 0xb7, 0x9b, 0x6e, 0x54, 0x89, 0xe0, 0x8a,
	0xa2, 0xe7, 0x50, 0x91, 0xf9, 0xd9, 0x3a, 0x5e, 0xdd, 0xdb, 0x99, 0x97, 0xb3, 0x37, 0x6e, 0xe3,
	0x9b, 0xbb, 0xfe, 0xaf, 0x45, 0x78, 0xf0, 0x26, 0x7d, 0x1d, 0x4a, 0x54, 0x4a, 0x21, 0xf3, 0x39,
	0x47, 0x13, 0x6a, 0x99, 0xc4, 0x8d, 0xae, 0xd9, 0x17, 0xd8, 0x1a, 0xa0, 0x10, 0x56, 0x26, 0xbd,
	0x53, 0x30, 0x61, 0x34, 0xef, 0x2f, 0x5d, 0xee, 0x2b, 0x5b, 0x59, 0xb6, 0xbb, 0xf0, 0xe4, 0x3e,
	0xfa, 0x00, 0xaa, 0xf6, 0x18, 0x31, 0x3e, 0xa0, 0xd7, 0x66, 0x50, 0x4a, 0x78, 0xd5, 0x62, 0x61,
	0x06, 0xa1, 0x7e, 0x36, 0xc8, 0xb6, 0xc5, 0xcc, 0x7c, 0xac, 0xed, 0x7d, 0xbb, 0xf0, 0xab, 0x1b,
	0x77, 0x9a, 0x13, 0x4f, 0xa9, 0xfc, 0x5f, 0x1c, 0x58, 0xbf, 0xa3, 0x45, 0xdb, 0xb0, 0x15, 0x74,
	0x0e, 0xcf, 0x4e, 0xc3, 0x4e, 0x2f, 0xc0, 0x51, 0xf0, 0x5d, 0xd0, 0xe9, 0xdd, 0xe9, 0xa1, 0xff,
	0xc3, 0x7a, 0xb7, 0xd7, 0xc2, 0xbd, 0xe8, 0xf4, 0x28, 0xea, 0x9e, 0x05, 0x41, 0xfb, 0x85, 0xeb,
	0xa0, 0x07, 0x50, 0x0b, 0x3a, 0x87, 0x33, 0x50, 0x01, 0xb9, 0x50, 0xcd, 0xa1, 0x56, 0xff, 0x30,
	0x3c, 0x75, 0x8b, 0x68, 0x03, 0xdc, 0x1c, 0xe9, 0xf7, 0x7a, 0x01, 0x6e, 0x75, 0xda, 0x81, 0xbb,
	0xe4, 0xff, 0xe9, 0xc0, 0xa3, 0x39, 0x49, 0x42, 0xaf, 0xa0, 0x7a, 0x6b, 0x39, 0xd8, 0x92, 0x7f,
	0xb9, 0x70, 0xae, 0x67, 0x56, 0x08, 0xbe, 0xc5, 0x84, 0x1e, 0x43, 0x99, 0xa9, 0xe8, 0x82, 0x71,
	0x32, 0x32, 0x1d, 0x58, 0xc6, 0x2b, 0x4c, 0x1d, 0x65, 0x22, 0xda, 0x82, 0x8a, 0xd2, 0xe4, 0x9c,
	0x8d, 0x98, 0x7e, 0x6d, 0xaa, 0x51, 0xc0, 0x37, 0x80, 0xff, 0x03, 0x6c, 0xdd, 0xe7, 0x26, 0xdb,
	0x3e, 0x5a, 0x12, 0xae, 0x62, 0xc9, 0x12, 0xdb, 0xf2, 0x15, 0x3c, 0x83, 0xe4, 0xdb, 0xe9, 0x82,
	0x0d, 0x28, 0x8f, 0xed, 0xe2, 0x2c, 0xe0, 0x19, 0x64, 0xef, 0xb7, 0x02, 0x2c, 0x5b, 0x07, 0x68,
	0x00, 0x95, 0x69, 0x39, 0x51, 0x7d, 0x81, 0x8a, 0x9b, 0x89, 0xdb, 0x5c, 0x7c, 0x22, 0xea, 0xce,
	0xe7, 0x0e, 0xfa, 0xc3, 0x81, 0xf7, 0xde, 0x3a, 0x75, 0xef, 0xe0, 0xf2, 0xab, 0x79, 0x96, 0xf7,
	0x8e, 0xb3, 0xff, 0xf4, 0xe7, 0xbf, 0xff, 0xfd, 0xbd, 0xf0, 0xd8, 0xdf, 0xc8, 0xfe, 0x38, 0xd8,
	0x4b, 0xfb, 0x72, 0x62, 0xb5, 0xef, 0x7c, 0x7a, 0xf0, 0x19, 0x6c, 0xc6, 0x62, 0x3c, 0x87, 0xfc,
	0x60, 0xd5, 0xe6, 0xe9, 0x2c, 0xfb, 0x84, 0x9f, 0x39, 0xe7, 0xcb, 0xe6, 0x5b, 0xfe, 0xc5, 0x7f,
	0x01, 0x00, 0x00, 0xff, 0xff, 0xc1, 0xa9, 0xf0, 0xc8, 0xb9, 0x08, 0x00, 0x00,
}
