// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/serviceconfig/monitoring.proto
// DO NOT EDIT!

package google_api // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Monitoring configuration of the service.
//
// The example below shows how to configure monitored resources and metrics
// for monitoring. In the example, a monitored resource and two metrics are
// defined. The `library.googleapis.com/book/returned_count` metric is sent
// to both producer and consumer projects, whereas the
// `library.googleapis.com/book/overdue_count` metric is only sent to the
// consumer project.
//
//     monitored_resources:
//     - type: library.googleapis.com/branch
//       labels:
//       - key: /city
//         description: The city where the library branch is located in.
//       - key: /name
//         description: The name of the branch.
//     metrics:
//     - name: library.googleapis.com/book/returned_count
//       metric_kind: DELTA
//       value_type: INT64
//       labels:
//       - key: /customer_id
//     - name: library.googleapis.com/book/overdue_count
//       metric_kind: GAUGE
//       value_type: INT64
//       labels:
//       - key: /customer_id
//     monitoring:
//       producer_destinations:
//       - monitored_resource: library.googleapis.com/branch
//         metrics:
//         - library.googleapis.com/book/returned_count
//       consumer_destinations:
//       - monitored_resource: library.googleapis.com/branch
//         metrics:
//         - library.googleapis.com/book/returned_count
//         - library.googleapis.com/book/overdue_count
type Monitoring struct {
	// Monitoring configurations for sending metrics to the producer project.
	// There can be multiple producer destinations, each one must have a
	// different monitored resource type. A metric can be used in at most
	// one producer destination.
	ProducerDestinations []*Monitoring_MonitoringDestination `protobuf:"bytes,1,rep,name=producer_destinations,json=producerDestinations" json:"producer_destinations,omitempty"`
	// Monitoring configurations for sending metrics to the consumer project.
	// There can be multiple consumer destinations, each one must have a
	// different monitored resource type. A metric can be used in at most
	// one consumer destination.
	ConsumerDestinations []*Monitoring_MonitoringDestination `protobuf:"bytes,2,rep,name=consumer_destinations,json=consumerDestinations" json:"consumer_destinations,omitempty"`
}

func (m *Monitoring) Reset()                    { *m = Monitoring{} }
func (m *Monitoring) String() string            { return proto.CompactTextString(m) }
func (*Monitoring) ProtoMessage()               {}
func (*Monitoring) Descriptor() ([]byte, []int) { return fileDescriptor12, []int{0} }

func (m *Monitoring) GetProducerDestinations() []*Monitoring_MonitoringDestination {
	if m != nil {
		return m.ProducerDestinations
	}
	return nil
}

func (m *Monitoring) GetConsumerDestinations() []*Monitoring_MonitoringDestination {
	if m != nil {
		return m.ConsumerDestinations
	}
	return nil
}

// Configuration of a specific monitoring destination (the producer project
// or the consumer project).
type Monitoring_MonitoringDestination struct {
	// The monitored resource type. The type must be defined in
	// [Service.monitored_resources][google.api.Service.monitored_resources] section.
	MonitoredResource string `protobuf:"bytes,1,opt,name=monitored_resource,json=monitoredResource" json:"monitored_resource,omitempty"`
	// Names of the metrics to report to this monitoring destination.
	// Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
	Metrics []string `protobuf:"bytes,2,rep,name=metrics" json:"metrics,omitempty"`
}

func (m *Monitoring_MonitoringDestination) Reset()         { *m = Monitoring_MonitoringDestination{} }
func (m *Monitoring_MonitoringDestination) String() string { return proto.CompactTextString(m) }
func (*Monitoring_MonitoringDestination) ProtoMessage()    {}
func (*Monitoring_MonitoringDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor12, []int{0, 0}
}

func init() {
	proto.RegisterType((*Monitoring)(nil), "google.api.Monitoring")
	proto.RegisterType((*Monitoring_MonitoringDestination)(nil), "google.api.Monitoring.MonitoringDestination")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/serviceconfig/monitoring.proto", fileDescriptor12)
}

var fileDescriptor12 = []byte{
	// 264 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x90, 0xd1, 0x4a, 0xc3, 0x30,
	0x14, 0x86, 0x69, 0x15, 0x65, 0x11, 0x14, 0x8b, 0x83, 0xb2, 0xab, 0xe1, 0xd5, 0x10, 0x4d, 0x40,
	0x9f, 0xc0, 0x21, 0xe8, 0x2e, 0x84, 0xd2, 0x17, 0x98, 0x31, 0x3d, 0x86, 0x03, 0xeb, 0x39, 0x21,
	0x49, 0x7d, 0x20, 0x9f, 0xc1, 0x07, 0x94, 0xad, 0xed, 0x5a, 0x64, 0x57, 0xbb, 0x6b, 0xf3, 0xff,
	0xe7, 0xff, 0x7e, 0x7e, 0xf1, 0x66, 0x99, 0xed, 0x06, 0xa4, 0xe5, 0x8d, 0x26, 0x2b, 0xd9, 0x5b,
	0x65, 0x81, 0x9c, 0xe7, 0xc8, 0xaa, 0x95, 0xb4, 0xc3, 0xa0, 0xb4, 0x43, 0x15, 0xc0, 0x7f, 0xa3,
	0x01, 0xc3, 0xf4, 0x85, 0x56, 0xd5, 0x4c, 0x18, 0xd9, 0x23, 0x59, 0xb9, 0x73, 0x67, 0xa2, 0x4b,
	0xd2, 0x0e, 0x67, 0xab, 0x63, 0x53, 0x35, 0x11, 0x47, 0x1d, 0x91, 0x29, 0xb4, 0xb1, 0xb7, 0xbf,
	0xa9, 0x10, 0xef, 0x7b, 0x56, 0xa6, 0xc5, 0xd4, 0x79, 0xae, 0x1a, 0x03, 0x7e, 0x5d, 0x41, 0x88,
	0x48, 0xad, 0x3b, 0x4f, 0xe6, 0x27, 0x8b, 0x8b, 0xc7, 0x7b, 0x39, 0xb4, 0x90, 0xc3, 0xd9, 0xe8,
	0xf3, 0x65, 0x38, 0x2a, 0x6f, 0xfa, 0xa8, 0xd1, 0x63, 0xd8, 0x22, 0x0c, 0x53, 0x68, 0xea, 0xff,
	0x88, 0xf4, 0x18, 0x44, 0x1f, 0x35, 0x46, 0xcc, 0x3e, 0xc4, 0xf4, 0xa0, 0x3d, 0x7b, 0x10, 0x59,
	0x37, 0x2c, 0x54, 0x6b, 0x0f, 0x81, 0x1b, 0x6f, 0x20, 0x4f, 0xe6, 0xc9, 0x62, 0x52, 0x5e, 0xef,
	0x95, 0xb2, 0x13, 0xb2, 0x5c, 0x9c, 0xd7, 0x10, 0x3d, 0x9a, 0xb6, 0xdc, 0xa4, 0xec, 0x7f, 0x97,
	0x77, 0xe2, 0xd2, 0x70, 0x3d, 0xaa, 0xba, 0xbc, 0x1a, 0x88, 0xc5, 0x76, 0xd9, 0x22, 0xf9, 0x49,
	0x4f, 0x5f, 0x9f, 0x8b, 0xd5, 0xe7, 0xd9, 0x6e, 0xe9, 0xa7, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x1a, 0x02, 0x76, 0xbb, 0x0c, 0x02, 0x00, 0x00,
}
