
/*
     This file is part of GNUnet.
     (C) 2005, 2006 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/content_tracking.c
 * @brief code for tracking available content
 * @author Christian Grothoff
 */

#include "platform.h"
#include "gnunetgtk_common.h"
#include "fs.h"
#include "helper.h"
#include "meta.h"
#include "namespace.h"
#include "content_tracking.h"
#include <GNUnet/gnunet_util_crypto.h>
#include <GNUnet/gnunet_uritrack_lib.h>
#include <GNUnet/gnunet_namespace_lib.h>
#include <extractor.h>

static void *
clearContentList (void *mdl)
{
  GtkTreeModel *model = GTK_TREE_MODEL (mdl);
  struct GNUNET_ECRS_URI *uri;
  struct GNUNET_MetaData *meta;
  GtkTreeIter iter;

  GNUNET_GTK_DEBUG_BEGIN ();
  if (gtk_tree_model_get_iter_first (model, &iter))
    {
      do
        {
          gtk_tree_model_get (model,
                              &iter,
                              NAMESPACE_URI, &uri, NAMESPACE_META, &meta, -1);
          GNUNET_ECRS_uri_destroy (uri);
          GNUNET_meta_data_destroy (meta);
          gtk_list_store_set (GTK_LIST_STORE (model),
                              &iter,
                              NAMESPACE_URI, NULL, NAMESPACE_META, NULL, -1);
        }
      while (gtk_list_store_remove (GTK_LIST_STORE (model), &iter));
    }
  GNUNET_GTK_DEBUG_END ();
  return NULL;
}


void
on_clearAvailableContentButton_clicked_fs (GtkWidget * dummy1,
                                           GtkWidget * dummy2)
{
  GtkWidget *contentList;
  GtkTreeModel *model;

  GNUNET_GTK_DEBUG_BEGIN ();
  contentList =
    glade_xml_get_widget (GNUNET_GTK_get_main_glade_XML (),
                          "availableContentList");
  model = gtk_tree_view_get_model (GTK_TREE_VIEW (contentList));
  GNUNET_URITRACK_clear (ectx, cfg);
  GNUNET_GTK_save_call (&clearContentList, model);
  GNUNET_GTK_DEBUG_END ();
}

void
on_trackingCheckButton_toggled_fs (GtkWidget * dummy1, GtkWidget * dummy2)
{
  GtkWidget *trackCheckButton;

  trackCheckButton
    =
    glade_xml_get_widget (GNUNET_GTK_get_main_glade_XML (),
                          "trackingCheckButton");
  GNUNET_URITRACK_toggle_tracking (ectx, cfg,
                                   gtk_toggle_button_get_active
                                   (GTK_TOGGLE_BUTTON (trackCheckButton)) ==
                                   TRUE ? GNUNET_YES : GNUNET_NO);
}



/**
 * Add the given content to the globally available
 * content model.  Check that it is not already
 * present!
 */
static void *
updateView (void *cls)
{
  const GNUNET_ECRS_FileInfo *fi = cls;
  GtkTreeIter iter;
  char *filename;
  char *uriString;
  unsigned long long size;
  char *size_h;
  GtkWidget *contentList;
  GtkTreeModel *model;

  contentList =
    glade_xml_get_widget (GNUNET_GTK_get_main_glade_XML (),
                          "availableContentList");
  model = gtk_tree_view_get_model (GTK_TREE_VIEW (contentList));
  filename = GNUNET_meta_data_get_first_by_types (fi->meta,
                                                  EXTRACTOR_FILENAME,
                                                  EXTRACTOR_TITLE,
                                                  EXTRACTOR_DESCRIPTION,
                                                  EXTRACTOR_SUBJECT,
                                                  EXTRACTOR_ARTIST,
                                                  EXTRACTOR_AUTHOR,
                                                  EXTRACTOR_PUBLISHER,
                                                  EXTRACTOR_CREATOR,
                                                  EXTRACTOR_PRODUCER,
                                                  EXTRACTOR_UNKNOWN, -1);
  if (filename == NULL)
    {
      filename = GNUNET_strdup (_("no name given"));
    }
  else
    {
      char *dotdot;

      while (NULL != (dotdot = strstr (filename, "..")))
        dotdot[0] = dotdot[1] = '_';
      filename = GNUNET_GTK_validate_utf8 (filename);
    }

  if (GNUNET_ECRS_uri_test_chk (fi->uri))
    size = GNUNET_ECRS_uri_get_file_size (fi->uri);
  else
    size = 0;
  uriString = GNUNET_ECRS_uri_to_string (fi->uri);
  gtk_list_store_append (GTK_LIST_STORE (model), &iter);
  size_h = GNUNET_get_byte_size_as_fancy_string (size);
  gtk_list_store_set (GTK_LIST_STORE (model),
                      &iter,
                      NAMESPACE_FILENAME, filename,
                      NAMESPACE_SIZE, size,
                      NAMESPACE_HSIZE, size_h,
                      NAMESPACE_URISTRING, uriString,
                      NAMESPACE_URI, GNUNET_ECRS_uri_duplicate (fi->uri),
                      NAMESPACE_META,
                      GNUNET_meta_data_duplicate (fi->meta), -1);
  GNUNET_free (size_h);
  GNUNET_free (filename);
  GNUNET_free (uriString);
  return NULL;
}

/**
 * Add the given content to the globally available
 * content model.  Check that it is not already
 * present!
 */
int
updateViewSave (const GNUNET_ECRS_FileInfo * fi,
                const GNUNET_HashCode * key, int isRoot, void *closure)
{
  GNUNET_GTK_save_call (&updateView, (void *) fi);
  return GNUNET_OK;
}
