/* IDBusDeviceGroup.c generated by valac 0.15.2.10-1402f-dirty, the Vala compiler
 * generated from IDBusDeviceGroup.vala, do not modify */

/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_ID_BUS_DEVICE_GROUP (dvb_id_bus_device_group_get_type ())
#define DVB_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroup))
#define DVB_IS_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP))
#define DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroupIface))

typedef struct _DVBIDBusDeviceGroup DVBIDBusDeviceGroup;
typedef struct _DVBIDBusDeviceGroupIface DVBIDBusDeviceGroupIface;

#define DVB_TYPE_ID_BUS_DEVICE_GROUP_PROXY (dvb_id_bus_device_group_proxy_get_type ())
typedef GDBusProxy DVBIDBusDeviceGroupProxy;
typedef GDBusProxyClass DVBIDBusDeviceGroupProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DVBIDBusDeviceGroupIface {
	GTypeInterface parent_iface;
	gchar* (*GetType) (DVBIDBusDeviceGroup* self, GError** error);
	char* (*GetRecorder) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*AddDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	gboolean (*RemoveDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	char* (*GetChannelList) (DVBIDBusDeviceGroup* self, GError** error);
	gchar* (*GetName) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetName) (DVBIDBusDeviceGroup* self, const gchar* name, GError** error);
	gchar** (*GetMembers) (DVBIDBusDeviceGroup* self, int* result_length1, GError** error);
	gboolean (*GetSchedule) (DVBIDBusDeviceGroup* self, guint channel_sid, char** opath, GError** error);
	gchar* (*GetRecordingsDirectory) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetRecordingsDirectory) (DVBIDBusDeviceGroup* self, const gchar* location, GError** error);
};



GType dvb_id_bus_device_group_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_device_group_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_device_group_get_type (void) G_GNUC_CONST;
gchar* dvb_id_bus_device_group_GetType (DVBIDBusDeviceGroup* self, GError** error);
char* dvb_id_bus_device_group_GetRecorder (DVBIDBusDeviceGroup* self, GError** error);
gboolean dvb_id_bus_device_group_AddDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
gboolean dvb_id_bus_device_group_RemoveDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
char* dvb_id_bus_device_group_GetChannelList (DVBIDBusDeviceGroup* self, GError** error);
gchar* dvb_id_bus_device_group_GetName (DVBIDBusDeviceGroup* self, GError** error);
gboolean dvb_id_bus_device_group_SetName (DVBIDBusDeviceGroup* self, const gchar* name, GError** error);
gchar** dvb_id_bus_device_group_GetMembers (DVBIDBusDeviceGroup* self, int* result_length1, GError** error);
gboolean dvb_id_bus_device_group_GetSchedule (DVBIDBusDeviceGroup* self, guint channel_sid, char** opath, GError** error);
gchar* dvb_id_bus_device_group_GetRecordingsDirectory (DVBIDBusDeviceGroup* self, GError** error);
gboolean dvb_id_bus_device_group_SetRecordingsDirectory (DVBIDBusDeviceGroup* self, const gchar* location, GError** error);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void dvb_id_bus_device_group_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_device_group_device_added (DVBIDBusDeviceGroup* self, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_device_group_device_removed (DVBIDBusDeviceGroup* self, GVariant* parameters);
static gchar* dvb_id_bus_device_group_proxy_GetType (DVBIDBusDeviceGroup* self, GError** error);
static char* dvb_id_bus_device_group_proxy_GetRecorder (DVBIDBusDeviceGroup* self, GError** error);
static gboolean dvb_id_bus_device_group_proxy_AddDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
static gboolean dvb_id_bus_device_group_proxy_RemoveDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
static char* dvb_id_bus_device_group_proxy_GetChannelList (DVBIDBusDeviceGroup* self, GError** error);
static gchar* dvb_id_bus_device_group_proxy_GetName (DVBIDBusDeviceGroup* self, GError** error);
static gboolean dvb_id_bus_device_group_proxy_SetName (DVBIDBusDeviceGroup* self, const gchar* name, GError** error);
static gchar** dvb_id_bus_device_group_proxy_GetMembers (DVBIDBusDeviceGroup* self, int* result_length1, GError** error);
static gboolean dvb_id_bus_device_group_proxy_GetSchedule (DVBIDBusDeviceGroup* self, guint channel_sid, char** opath, GError** error);
static gchar* dvb_id_bus_device_group_proxy_GetRecordingsDirectory (DVBIDBusDeviceGroup* self, GError** error);
static gboolean dvb_id_bus_device_group_proxy_SetRecordingsDirectory (DVBIDBusDeviceGroup* self, const gchar* location, GError** error);
static void dvb_id_bus_device_group_proxy_dvb_id_bus_device_group_interface_init (DVBIDBusDeviceGroupIface* iface);
static void _dbus_dvb_id_bus_device_group_GetType (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_device_group_GetRecorder (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_device_group_AddDevice (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_device_group_RemoveDevice (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_device_group_GetChannelList (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_device_group_GetName (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_device_group_SetName (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_device_group_GetMembers (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_device_group_GetSchedule (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_device_group_GetRecordingsDirectory (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_device_group_SetRecordingsDirectory (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void dvb_id_bus_device_group_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* dvb_id_bus_device_group_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean dvb_id_bus_device_group_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_dvb_id_bus_device_group_device_added (GObject* _sender, guint adapter, guint frontend, gpointer* _data);
static void _dbus_dvb_id_bus_device_group_device_removed (GObject* _sender, guint adapter, guint frontend, gpointer* _data);
static void _dvb_id_bus_device_group_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_GetType_result = {-1, "result", "s"};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetType_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetType_out[] = {&_dvb_id_bus_device_group_dbus_arg_info_GetType_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_device_group_dbus_method_info_GetType = {-1, "GetType", (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetType_in), (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetType_out)};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_GetRecorder_result = {-1, "result", "o"};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetRecorder_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetRecorder_out[] = {&_dvb_id_bus_device_group_dbus_arg_info_GetRecorder_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_device_group_dbus_method_info_GetRecorder = {-1, "GetRecorder", (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetRecorder_in), (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetRecorder_out)};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_AddDevice_adapter = {-1, "adapter", "u"};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_AddDevice_frontend = {-1, "frontend", "u"};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_AddDevice_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_AddDevice_in[] = {&_dvb_id_bus_device_group_dbus_arg_info_AddDevice_adapter, &_dvb_id_bus_device_group_dbus_arg_info_AddDevice_frontend, NULL};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_AddDevice_out[] = {&_dvb_id_bus_device_group_dbus_arg_info_AddDevice_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_device_group_dbus_method_info_AddDevice = {-1, "AddDevice", (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_AddDevice_in), (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_AddDevice_out)};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_RemoveDevice_adapter = {-1, "adapter", "u"};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_RemoveDevice_frontend = {-1, "frontend", "u"};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_RemoveDevice_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_RemoveDevice_in[] = {&_dvb_id_bus_device_group_dbus_arg_info_RemoveDevice_adapter, &_dvb_id_bus_device_group_dbus_arg_info_RemoveDevice_frontend, NULL};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_RemoveDevice_out[] = {&_dvb_id_bus_device_group_dbus_arg_info_RemoveDevice_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_device_group_dbus_method_info_RemoveDevice = {-1, "RemoveDevice", (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_RemoveDevice_in), (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_RemoveDevice_out)};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_GetChannelList_result = {-1, "result", "o"};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetChannelList_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetChannelList_out[] = {&_dvb_id_bus_device_group_dbus_arg_info_GetChannelList_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_device_group_dbus_method_info_GetChannelList = {-1, "GetChannelList", (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetChannelList_in), (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetChannelList_out)};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_GetName_result = {-1, "result", "s"};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetName_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetName_out[] = {&_dvb_id_bus_device_group_dbus_arg_info_GetName_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_device_group_dbus_method_info_GetName = {-1, "GetName", (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetName_in), (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetName_out)};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_SetName_name = {-1, "name", "s"};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_SetName_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_SetName_in[] = {&_dvb_id_bus_device_group_dbus_arg_info_SetName_name, NULL};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_SetName_out[] = {&_dvb_id_bus_device_group_dbus_arg_info_SetName_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_device_group_dbus_method_info_SetName = {-1, "SetName", (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_SetName_in), (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_SetName_out)};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_GetMembers_result = {-1, "result", "as"};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetMembers_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetMembers_out[] = {&_dvb_id_bus_device_group_dbus_arg_info_GetMembers_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_device_group_dbus_method_info_GetMembers = {-1, "GetMembers", (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetMembers_in), (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetMembers_out)};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_GetSchedule_channel_sid = {-1, "channel_sid", "u"};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_GetSchedule_opath = {-1, "opath", "o"};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_GetSchedule_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetSchedule_in[] = {&_dvb_id_bus_device_group_dbus_arg_info_GetSchedule_channel_sid, NULL};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetSchedule_out[] = {&_dvb_id_bus_device_group_dbus_arg_info_GetSchedule_opath, &_dvb_id_bus_device_group_dbus_arg_info_GetSchedule_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_device_group_dbus_method_info_GetSchedule = {-1, "GetSchedule", (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetSchedule_in), (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetSchedule_out)};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_GetRecordingsDirectory_result = {-1, "result", "s"};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetRecordingsDirectory_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_GetRecordingsDirectory_out[] = {&_dvb_id_bus_device_group_dbus_arg_info_GetRecordingsDirectory_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_device_group_dbus_method_info_GetRecordingsDirectory = {-1, "GetRecordingsDirectory", (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetRecordingsDirectory_in), (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_GetRecordingsDirectory_out)};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_SetRecordingsDirectory_location = {-1, "location", "s"};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_SetRecordingsDirectory_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_SetRecordingsDirectory_in[] = {&_dvb_id_bus_device_group_dbus_arg_info_SetRecordingsDirectory_location, NULL};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_SetRecordingsDirectory_out[] = {&_dvb_id_bus_device_group_dbus_arg_info_SetRecordingsDirectory_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_device_group_dbus_method_info_SetRecordingsDirectory = {-1, "SetRecordingsDirectory", (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_SetRecordingsDirectory_in), (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_SetRecordingsDirectory_out)};
static const GDBusMethodInfo * const _dvb_id_bus_device_group_dbus_method_info[] = {&_dvb_id_bus_device_group_dbus_method_info_GetType, &_dvb_id_bus_device_group_dbus_method_info_GetRecorder, &_dvb_id_bus_device_group_dbus_method_info_AddDevice, &_dvb_id_bus_device_group_dbus_method_info_RemoveDevice, &_dvb_id_bus_device_group_dbus_method_info_GetChannelList, &_dvb_id_bus_device_group_dbus_method_info_GetName, &_dvb_id_bus_device_group_dbus_method_info_SetName, &_dvb_id_bus_device_group_dbus_method_info_GetMembers, &_dvb_id_bus_device_group_dbus_method_info_GetSchedule, &_dvb_id_bus_device_group_dbus_method_info_GetRecordingsDirectory, &_dvb_id_bus_device_group_dbus_method_info_SetRecordingsDirectory, NULL};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_device_added_adapter = {-1, "adapter", "u"};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_device_added_frontend = {-1, "frontend", "u"};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_device_added[] = {&_dvb_id_bus_device_group_dbus_arg_info_device_added_adapter, &_dvb_id_bus_device_group_dbus_arg_info_device_added_frontend, NULL};
static const GDBusSignalInfo _dvb_id_bus_device_group_dbus_signal_info_device_added = {-1, "DeviceAdded", (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_device_added)};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_device_removed_adapter = {-1, "adapter", "u"};
static const GDBusArgInfo _dvb_id_bus_device_group_dbus_arg_info_device_removed_frontend = {-1, "frontend", "u"};
static const GDBusArgInfo * const _dvb_id_bus_device_group_dbus_arg_info_device_removed[] = {&_dvb_id_bus_device_group_dbus_arg_info_device_removed_adapter, &_dvb_id_bus_device_group_dbus_arg_info_device_removed_frontend, NULL};
static const GDBusSignalInfo _dvb_id_bus_device_group_dbus_signal_info_device_removed = {-1, "DeviceRemoved", (GDBusArgInfo **) (&_dvb_id_bus_device_group_dbus_arg_info_device_removed)};
static const GDBusSignalInfo * const _dvb_id_bus_device_group_dbus_signal_info[] = {&_dvb_id_bus_device_group_dbus_signal_info_device_added, &_dvb_id_bus_device_group_dbus_signal_info_device_removed, NULL};
static const GDBusPropertyInfo * const _dvb_id_bus_device_group_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _dvb_id_bus_device_group_dbus_interface_info = {-1, "org.gnome.DVB.DeviceGroup", (GDBusMethodInfo **) (&_dvb_id_bus_device_group_dbus_method_info), (GDBusSignalInfo **) (&_dvb_id_bus_device_group_dbus_signal_info), (GDBusPropertyInfo **) (&_dvb_id_bus_device_group_dbus_property_info)};
static const GDBusInterfaceVTable _dvb_id_bus_device_group_dbus_interface_vtable = {dvb_id_bus_device_group_dbus_interface_method_call, dvb_id_bus_device_group_dbus_interface_get_property, dvb_id_bus_device_group_dbus_interface_set_property};

/**
         * @returns: Name of adapter type the group holds
         * or an empty string when group with given id doesn't exist.
         */
gchar* dvb_id_bus_device_group_GetType (DVBIDBusDeviceGroup* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetType (self, error);
}


/**
         * @returns: Object path of the device's recorder
         * 
         * Returns the object path to the device's recorder.
         */
char* dvb_id_bus_device_group_GetRecorder (DVBIDBusDeviceGroup* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetRecorder (self, error);
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @group_id: ID of device group
         * @returns: TRUE when the device has been registered successfully
         *
         * Creates a new device and adds it to the specified DeviceGroup.
         * The new device will inherit all settings from the group's
         * reference device.
         */
gboolean dvb_id_bus_device_group_AddDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->AddDevice (self, adapter, frontend, error);
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @returns: TRUE when device has been removed successfully
         *
         * Removes the device from the group. If the group contains
         * no devices after the removal it's removed as well.
         */
gboolean dvb_id_bus_device_group_RemoveDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->RemoveDevice (self, adapter, frontend, error);
}


/**
         * @returns: Object path to the ChannelList service for this device
         */
char* dvb_id_bus_device_group_GetChannelList (DVBIDBusDeviceGroup* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetChannelList (self, error);
}


/**
         * @returns: Name of the device group
         */
gchar* dvb_id_bus_device_group_GetName (DVBIDBusDeviceGroup* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetName (self, error);
}


/**
         * @name: Name of the group
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_device_group_SetName (DVBIDBusDeviceGroup* self, const gchar* name, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->SetName (self, name, error);
}


/**
         * @returns: List of paths to the devices that are part of
         * the group (e.g. /dev/dvb/adapter0/frontend0)
         */
gchar** dvb_id_bus_device_group_GetMembers (DVBIDBusDeviceGroup* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetMembers (self, result_length1, error);
}


/**
         * @channel_sid: ID of the channel
         * @opath: Object path to Schedule service
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_device_group_GetSchedule (DVBIDBusDeviceGroup* self, guint channel_sid, char** opath, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetSchedule (self, channel_sid, opath, error);
}


/**
         * @returns: Location of the recordings directory
         */
gchar* dvb_id_bus_device_group_GetRecordingsDirectory (DVBIDBusDeviceGroup* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->GetRecordingsDirectory (self, error);
}


/**
         * @location: Location of the recordings directory
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_device_group_SetRecordingsDirectory (DVBIDBusDeviceGroup* self, const gchar* location, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE (self)->SetRecordingsDirectory (self, location, error);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void dvb_id_bus_device_group_base_init (DVBIDBusDeviceGroupIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("device_added", DVB_TYPE_ID_BUS_DEVICE_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_signal_new ("device_removed", DVB_TYPE_ID_BUS_DEVICE_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	}
}


GType dvb_id_bus_device_group_get_type (void) {
	static volatile gsize dvb_id_bus_device_group_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_id_bus_device_group_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusDeviceGroupIface), (GBaseInitFunc) dvb_id_bus_device_group_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dvb_id_bus_device_group_type_id;
		dvb_id_bus_device_group_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusDeviceGroup", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_device_group_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_device_group_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) dvb_id_bus_device_group_proxy_get_type);
		g_type_set_qdata (dvb_id_bus_device_group_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.DVB.DeviceGroup");
		g_type_set_qdata (dvb_id_bus_device_group_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) dvb_id_bus_device_group_register_object);
		g_once_init_leave (&dvb_id_bus_device_group_type_id__volatile, dvb_id_bus_device_group_type_id);
	}
	return dvb_id_bus_device_group_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusDeviceGroupProxy, dvb_id_bus_device_group_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_DEVICE_GROUP, dvb_id_bus_device_group_proxy_dvb_id_bus_device_group_interface_init) )
static void dvb_id_bus_device_group_proxy_class_init (DVBIDBusDeviceGroupProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = dvb_id_bus_device_group_proxy_g_signal;
}


static void _dbus_handle_dvb_id_bus_device_group_device_added (DVBIDBusDeviceGroup* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint adapter = 0U;
	GVariant* _tmp89_;
	guint frontend = 0U;
	GVariant* _tmp90_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp89_ = g_variant_iter_next_value (&_arguments_iter);
	adapter = g_variant_get_uint32 (_tmp89_);
	g_variant_unref (_tmp89_);
	_tmp90_ = g_variant_iter_next_value (&_arguments_iter);
	frontend = g_variant_get_uint32 (_tmp90_);
	g_variant_unref (_tmp90_);
	g_signal_emit_by_name (self, "device-added", adapter, frontend);
}


static void _dbus_handle_dvb_id_bus_device_group_device_removed (DVBIDBusDeviceGroup* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint adapter = 0U;
	GVariant* _tmp91_;
	guint frontend = 0U;
	GVariant* _tmp92_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp91_ = g_variant_iter_next_value (&_arguments_iter);
	adapter = g_variant_get_uint32 (_tmp91_);
	g_variant_unref (_tmp91_);
	_tmp92_ = g_variant_iter_next_value (&_arguments_iter);
	frontend = g_variant_get_uint32 (_tmp92_);
	g_variant_unref (_tmp92_);
	g_signal_emit_by_name (self, "device-removed", adapter, frontend);
}


static void dvb_id_bus_device_group_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "DeviceAdded") == 0) {
		_dbus_handle_dvb_id_bus_device_group_device_added ((DVBIDBusDeviceGroup*) proxy, parameters);
	} else if (strcmp (signal_name, "DeviceRemoved") == 0) {
		_dbus_handle_dvb_id_bus_device_group_device_removed ((DVBIDBusDeviceGroup*) proxy, parameters);
	}
}


static void dvb_id_bus_device_group_proxy_init (DVBIDBusDeviceGroupProxy* self) {
}


static gchar* dvb_id_bus_device_group_proxy_GetType (DVBIDBusDeviceGroup* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp93_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.DeviceGroup", "GetType");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp93_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp93_, NULL);
	g_variant_unref (_tmp93_);
	g_object_unref (_reply_message);
	return _result;
}


static char* dvb_id_bus_device_group_proxy_GetRecorder (DVBIDBusDeviceGroup* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _result;
	GVariant* _tmp94_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.DeviceGroup", "GetRecorder");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp94_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp94_, NULL);
	g_variant_unref (_tmp94_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_device_group_proxy_AddDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp95_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.DeviceGroup", "AddDevice");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (adapter));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (frontend));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp95_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp95_);
	g_variant_unref (_tmp95_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_device_group_proxy_RemoveDevice (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp96_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.DeviceGroup", "RemoveDevice");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (adapter));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (frontend));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp96_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp96_);
	g_variant_unref (_tmp96_);
	g_object_unref (_reply_message);
	return _result;
}


static char* dvb_id_bus_device_group_proxy_GetChannelList (DVBIDBusDeviceGroup* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _result;
	GVariant* _tmp97_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.DeviceGroup", "GetChannelList");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp97_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp97_, NULL);
	g_variant_unref (_tmp97_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* dvb_id_bus_device_group_proxy_GetName (DVBIDBusDeviceGroup* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp98_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.DeviceGroup", "GetName");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp98_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp98_, NULL);
	g_variant_unref (_tmp98_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_device_group_proxy_SetName (DVBIDBusDeviceGroup* self, const gchar* name, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp99_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.DeviceGroup", "SetName");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp99_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp99_);
	g_variant_unref (_tmp99_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar** dvb_id_bus_device_group_proxy_GetMembers (DVBIDBusDeviceGroup* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	GVariant* _tmp100_;
	gchar** _tmp101_;
	int _tmp101__length;
	int _tmp101__size;
	int _tmp101__length1;
	GVariantIter _tmp102_;
	GVariant* _tmp103_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.DeviceGroup", "GetMembers");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp100_ = g_variant_iter_next_value (&_reply_iter);
	_tmp101_ = g_new (gchar*, 5);
	_tmp101__length = 0;
	_tmp101__size = 4;
	_tmp101__length1 = 0;
	g_variant_iter_init (&_tmp102_, _tmp100_);
	for (; (_tmp103_ = g_variant_iter_next_value (&_tmp102_)) != NULL; _tmp101__length1++) {
		if (_tmp101__size == _tmp101__length) {
			_tmp101__size = 2 * _tmp101__size;
			_tmp101_ = g_renew (gchar*, _tmp101_, _tmp101__size + 1);
		}
		_tmp101_[_tmp101__length++] = g_variant_dup_string (_tmp103_, NULL);
		g_variant_unref (_tmp103_);
	}
	_result_length1 = _tmp101__length1;
	_tmp101_[_tmp101__length] = NULL;
	_result = _tmp101_;
	g_variant_unref (_tmp100_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_device_group_proxy_GetSchedule (DVBIDBusDeviceGroup* self, guint channel_sid, char** opath, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _vala_opath;
	GVariant* _tmp104_;
	gboolean _result;
	GVariant* _tmp105_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.DeviceGroup", "GetSchedule");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (channel_sid));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp104_ = g_variant_iter_next_value (&_reply_iter);
	_vala_opath = g_variant_dup_string (_tmp104_, NULL);
	g_variant_unref (_tmp104_);
	*opath = _vala_opath;
	_tmp105_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp105_);
	g_variant_unref (_tmp105_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* dvb_id_bus_device_group_proxy_GetRecordingsDirectory (DVBIDBusDeviceGroup* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp106_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.DeviceGroup", "GetRecordingsDirectory");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp106_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp106_, NULL);
	g_variant_unref (_tmp106_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_device_group_proxy_SetRecordingsDirectory (DVBIDBusDeviceGroup* self, const gchar* location, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp107_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.DeviceGroup", "SetRecordingsDirectory");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (location));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp107_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp107_);
	g_variant_unref (_tmp107_);
	g_object_unref (_reply_message);
	return _result;
}


static void dvb_id_bus_device_group_proxy_dvb_id_bus_device_group_interface_init (DVBIDBusDeviceGroupIface* iface) {
	iface->GetType = dvb_id_bus_device_group_proxy_GetType;
	iface->GetRecorder = dvb_id_bus_device_group_proxy_GetRecorder;
	iface->AddDevice = dvb_id_bus_device_group_proxy_AddDevice;
	iface->RemoveDevice = dvb_id_bus_device_group_proxy_RemoveDevice;
	iface->GetChannelList = dvb_id_bus_device_group_proxy_GetChannelList;
	iface->GetName = dvb_id_bus_device_group_proxy_GetName;
	iface->SetName = dvb_id_bus_device_group_proxy_SetName;
	iface->GetMembers = dvb_id_bus_device_group_proxy_GetMembers;
	iface->GetSchedule = dvb_id_bus_device_group_proxy_GetSchedule;
	iface->GetRecordingsDirectory = dvb_id_bus_device_group_proxy_GetRecordingsDirectory;
	iface->SetRecordingsDirectory = dvb_id_bus_device_group_proxy_SetRecordingsDirectory;
}


static void _dbus_dvb_id_bus_device_group_GetType (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = dvb_id_bus_device_group_GetType (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_device_group_GetRecorder (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = dvb_id_bus_device_group_GetRecorder (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_device_group_AddDevice (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint adapter = 0U;
	GVariant* _tmp108_;
	guint frontend = 0U;
	GVariant* _tmp109_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp108_ = g_variant_iter_next_value (&_arguments_iter);
	adapter = g_variant_get_uint32 (_tmp108_);
	g_variant_unref (_tmp108_);
	_tmp109_ = g_variant_iter_next_value (&_arguments_iter);
	frontend = g_variant_get_uint32 (_tmp109_);
	g_variant_unref (_tmp109_);
	result = dvb_id_bus_device_group_AddDevice (self, adapter, frontend, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_device_group_RemoveDevice (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint adapter = 0U;
	GVariant* _tmp110_;
	guint frontend = 0U;
	GVariant* _tmp111_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp110_ = g_variant_iter_next_value (&_arguments_iter);
	adapter = g_variant_get_uint32 (_tmp110_);
	g_variant_unref (_tmp110_);
	_tmp111_ = g_variant_iter_next_value (&_arguments_iter);
	frontend = g_variant_get_uint32 (_tmp111_);
	g_variant_unref (_tmp111_);
	result = dvb_id_bus_device_group_RemoveDevice (self, adapter, frontend, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_device_group_GetChannelList (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = dvb_id_bus_device_group_GetChannelList (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_device_group_GetName (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = dvb_id_bus_device_group_GetName (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_device_group_SetName (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp112_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp112_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp112_, NULL);
	g_variant_unref (_tmp112_);
	result = dvb_id_bus_device_group_SetName (self, name, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (name);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_device_group_GetMembers (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp113_;
	GVariantBuilder _tmp114_;
	int _tmp115_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = dvb_id_bus_device_group_GetMembers (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp113_ = result;
	g_variant_builder_init (&_tmp114_, G_VARIANT_TYPE ("as"));
	for (_tmp115_ = 0; _tmp115_ < result_length1; _tmp115_++) {
		g_variant_builder_add_value (&_tmp114_, g_variant_new_string (*_tmp113_));
		_tmp113_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp114_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_device_group_GetSchedule (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint channel_sid = 0U;
	GVariant* _tmp116_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* opath = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp116_ = g_variant_iter_next_value (&_arguments_iter);
	channel_sid = g_variant_get_uint32 (_tmp116_);
	g_variant_unref (_tmp116_);
	result = dvb_id_bus_device_group_GetSchedule (self, channel_sid, &opath, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (opath));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (opath);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_device_group_GetRecordingsDirectory (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = dvb_id_bus_device_group_GetRecordingsDirectory (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_device_group_SetRecordingsDirectory (DVBIDBusDeviceGroup* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* location = NULL;
	GVariant* _tmp117_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp117_ = g_variant_iter_next_value (&_arguments_iter);
	location = g_variant_dup_string (_tmp117_, NULL);
	g_variant_unref (_tmp117_);
	result = dvb_id_bus_device_group_SetRecordingsDirectory (self, location, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (location);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void dvb_id_bus_device_group_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetType") == 0) {
		_dbus_dvb_id_bus_device_group_GetType (object, parameters, invocation);
	} else if (strcmp (method_name, "GetRecorder") == 0) {
		_dbus_dvb_id_bus_device_group_GetRecorder (object, parameters, invocation);
	} else if (strcmp (method_name, "AddDevice") == 0) {
		_dbus_dvb_id_bus_device_group_AddDevice (object, parameters, invocation);
	} else if (strcmp (method_name, "RemoveDevice") == 0) {
		_dbus_dvb_id_bus_device_group_RemoveDevice (object, parameters, invocation);
	} else if (strcmp (method_name, "GetChannelList") == 0) {
		_dbus_dvb_id_bus_device_group_GetChannelList (object, parameters, invocation);
	} else if (strcmp (method_name, "GetName") == 0) {
		_dbus_dvb_id_bus_device_group_GetName (object, parameters, invocation);
	} else if (strcmp (method_name, "SetName") == 0) {
		_dbus_dvb_id_bus_device_group_SetName (object, parameters, invocation);
	} else if (strcmp (method_name, "GetMembers") == 0) {
		_dbus_dvb_id_bus_device_group_GetMembers (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSchedule") == 0) {
		_dbus_dvb_id_bus_device_group_GetSchedule (object, parameters, invocation);
	} else if (strcmp (method_name, "GetRecordingsDirectory") == 0) {
		_dbus_dvb_id_bus_device_group_GetRecordingsDirectory (object, parameters, invocation);
	} else if (strcmp (method_name, "SetRecordingsDirectory") == 0) {
		_dbus_dvb_id_bus_device_group_SetRecordingsDirectory (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* dvb_id_bus_device_group_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean dvb_id_bus_device_group_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_dvb_id_bus_device_group_device_added (GObject* _sender, guint adapter, guint frontend, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (adapter));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (frontend));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.DeviceGroup", "DeviceAdded", _arguments, NULL);
}


static void _dbus_dvb_id_bus_device_group_device_removed (GObject* _sender, guint adapter, guint frontend, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (adapter));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (frontend));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.DeviceGroup", "DeviceRemoved", _arguments, NULL);
}


guint dvb_id_bus_device_group_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_dvb_id_bus_device_group_dbus_interface_info), &_dvb_id_bus_device_group_dbus_interface_vtable, data, _dvb_id_bus_device_group_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "device-added", (GCallback) _dbus_dvb_id_bus_device_group_device_added, data);
	g_signal_connect (object, "device-removed", (GCallback) _dbus_dvb_id_bus_device_group_device_removed, data);
	return result;
}


static void _dvb_id_bus_device_group_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dvb_id_bus_device_group_device_added, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dvb_id_bus_device_group_device_removed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



