/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/* gdm-info-provider-computer.c
 *
 * Copyright (C) 2007 David Zeuthen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <config.h>
#include <glib/gi18n.h>
#include "gdm-info-provider.h"

static gboolean 
get_provider_matches (GdmDevice *device)
{
        return g_ascii_strcasecmp (gdm_device_get_udi (device), "/org/freedesktop/Hal/devices/computer") == 0;
}

static char *
get_icon_name (GdmDevice *device)
{
        return g_strdup ("computer");
}

static char *
get_short_name (GdmDevice *device)
{
        return g_strdup ("Computer");
}

static char *
get_long_name (GdmDevice *device)
{
        return g_strdup ("Computer");
}

static char *
get_vendor (GdmDevice *device)
{
        return g_strdup (gdm_device_get_property_string (device, "system.hardware.vendor"));
}

static char *
get_product (GdmDevice *device)
{
        return g_strdup (gdm_device_get_property_string (device, "system.hardware.product"));
}

#define ADD_SUM(p, key, value)                                                       \
        do {                                                                         \
                if (value != NULL) {                                                 \
                        p = g_slist_append (p, g_strdup (key));                      \
                        p = g_slist_append (p, value);                               \
                }                                                                    \
        } while (FALSE)

static GSList *
get_summary (GdmDevice *device)
{
        const char *s;
        const char *s2;
        GSList *p = NULL;

        s = gdm_device_get_property_string (device, "system.hardware.product");
        s2 = gdm_device_get_property_string (device, "system.hardware.version");
        if (s != NULL && s2 != NULL)
                ADD_SUM (p, _("Model"), g_strdup_printf (_("%s (version %s)"), s, s2));
        else if (s != NULL)
                ADD_SUM (p, _("Model"), g_strdup (s));
        s = gdm_device_get_property_string (device, "system.hardware.vendor");
        if (s != NULL)
                ADD_SUM (p, _("Manufacturer"), g_strdup (s));
        s = gdm_device_get_property_string (device, "system.formfactor");
        if (s != NULL) {
                s2 = NULL;
                if (g_ascii_strcasecmp (s, "desktop") == 0)
                        s2 = _("Desktop");
                else if (g_ascii_strcasecmp (s, "laptop") == 0)
                        s2 = _("Laptop");
                else if (g_ascii_strcasecmp (s, "server") == 0)
                        s2 = _("Server");
                else if (g_ascii_strcasecmp (s, "handheld") == 0)
                        s2 = _("Handheld");
                if (s2 != NULL)
                        ADD_SUM (p, _("Form Factor"), g_strdup (s2));
        }
        s = gdm_device_get_property_string (device, "system.hardware.serial");
        if (s != NULL)
                ADD_SUM (p, _("Serial Number"), g_strdup (s));
        s = gdm_device_get_property_string (device, "system.hardware.uuid");
        if (s != NULL)
                ADD_SUM (p, _("UUID"), g_strdup (s));

        return p;
}

GdmInfoProviderIface gdm_info_provider_computer =
{
        .get_provider_matches = get_provider_matches,
        .get_icon_name        = get_icon_name,
        .get_short_name       = get_short_name,
        .get_long_name        = get_long_name,
        .get_vendor           = get_vendor,
        .get_product          = get_product,
        .get_summary          = get_summary,
};

