create table t_lfn (
  id int primary key,
  name varchar(500) not null,
  ref int default 0 not null
);
create sequence s_lfn_id start with 1 increment by 1;
create or replace trigger tr_lfn
  before insert on t_lfn
  for each row
  begin
    select s_lfn_id.nextval into :new.id from dual;
  end tr_lfn;
/
create unique index t_lfn_name on t_lfn(name);

create table t_pfn (
  id int primary key,
  name varchar(500) not null,
  ref int default 0 not null
);
create sequence s_pfn_id start with 1 increment by 1;
create or replace trigger tr_pfn
  before insert on t_pfn
  for each row
  begin
    select s_pfn_id.nextval into :new.id from dual;
  end tr_pfn;
/
create unique index t_pfn_name on t_pfn(name);

create table t_map (
  lfn_id int not null references t_lfn(id),
  pfn_id int not null references t_pfn(id)
);
alter table t_map add constraint pk_map primary key(lfn_id, pfn_id);
create index t_map_pfn_id on t_map(pfn_id);

create table t_rli (
  id int primary key,
  flags int default 0 not null,
  name varchar(500) not null
);
create sequence s_rli_id start with 1 increment by 1;
create or replace trigger tr_rli
  before insert on t_rli
  for each row
  begin
    select s_rli_id.nextval into :new.id from dual;
  end tr_rli;
/
create unique index t_rli_name on t_rli(name);

create table t_rlipartition (
  rli_id int not null references t_rli(id),
  pattern varchar(500) not null
);
alter table t_rlipartition add constraint pk_rlipartition primary key(rli_id, pattern);
create index t_rlipartition_pattern on t_rlipartition(pattern);

create table t_attribute (
  id int primary key,
  name varchar(500) not null,
  objtype int not null,
  type int not null
);
create sequence s_attribute_id start with 1 increment by 1;
create or replace trigger tr_attribute
  before insert on t_attribute
  for each row
  begin
    select s_attribute_id.nextval into :new.id from dual;
  end tr_attribute;
/
create unique index t_attribute_name_objtype on t_attribute(name, objtype);

create table t_date_attr (
  obj_id int not null,
  attr_id int not null references t_attribute(id),
  value timestamp not null
);
create index t_date_attr_attr_id on t_date_attr(attr_id);
create index t_date_attr_value on t_date_attr(value);
create unique index t_date_obj_id_attr_id on t_date_attr(obj_id, attr_id);

create table t_flt_attr (
  obj_id int not null,
  attr_id int not null references t_attribute(id),
  value float not null
);
create index t_flt_attr_attr_id on t_flt_attr(attr_id);
create index t_flt_attr_value on t_flt_attr(value);
create unique index t_flt_obj_id_attr_id on t_flt_attr(obj_id, attr_id);

create table t_int_attr (
  obj_id int not null,
  attr_id int not null references t_attribute(id),
  value int not null
);
create index t_int_attr_attr_id on t_int_attr(attr_id);
create index t_int_attr_value on t_int_attr(value);
create unique index t_int_obj_id_attr_id on t_int_attr(obj_id, attr_id);

create table t_str_attr (
  obj_id int not null,
  attr_id int not null references t_attribute(id),
  value varchar(500) not null
);
create index t_str_attr_attr_id on t_str_attr(attr_id);
create index t_str_attr_value on t_str_attr(value);
create unique index t_str_obj_id_attr_id on t_str_attr(obj_id, attr_id);
