/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-ui-cellrenderer.h"


enum {
  LAST_SIGNAL
};

enum {
  PROP_0,

#if 0
  PROP_TEXT,
#endif

  PROP_GTYPE,
  PROP_POINTER,
};

static void g_inspector_cell_renderer_class_init (GInspectorCellRendererClass *klass);
static void g_inspector_cell_renderer_init       (GInspectorCellRenderer      *inspector_cell_renderer);
static void g_inspector_cell_renderer_set_property (GObject      *object,
						    guint         param_id,
						    const GValue *value,
						    GParamSpec   *pspec);
static void g_inspector_cell_renderer_get_property (GObject      *object,
						    guint         param_id,
						    GValue       *value,
						    GParamSpec   *pspec);


static GtkCellRendererTextClass *parent_class = NULL;
#if 0
static guint inspector_cell_renderer_signals[LAST_SIGNAL] = { 0 };
#endif


GType
g_inspector_cell_renderer_get_type (void)
{
  static GType inspector_cell_renderer_type = 0;

  if (!inspector_cell_renderer_type)
    {
      static const GTypeInfo inspector_cell_renderer_info =
      {
        sizeof (GInspectorCellRendererClass),
        NULL,           /* base_init */
        NULL,           /* base_finalize */
        (GClassInitFunc) g_inspector_cell_renderer_class_init,
        NULL,           /* class_finalize */
        NULL,           /* class_data */
        sizeof (GInspectorCellRenderer),
        0,              /* n_preallocs */
        (GInstanceInitFunc) g_inspector_cell_renderer_init,
	NULL,		/* value_table */
      };

      inspector_cell_renderer_type
        = g_type_register_static (GTK_TYPE_CELL_RENDERER_TEXT,
                                  "GInspectorCellRenderer",
                                  &inspector_cell_renderer_info, 0);
    }

  return inspector_cell_renderer_type;
}

static void
g_inspector_cell_renderer_class_init (GInspectorCellRendererClass *klass)
{
  GObjectClass   *gobject_class;
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GInspectorCellRendererClass  *inspector_cell_renderer_class;


  gobject_class = G_OBJECT_CLASS (klass);
  object_class = (GtkObjectClass*) klass;
  widget_class = (GtkWidgetClass*) klass;
  inspector_cell_renderer_class = (GInspectorCellRendererClass*) klass;

  parent_class = g_type_class_peek_parent (klass);


  gobject_class->set_property = g_inspector_cell_renderer_set_property;
  gobject_class->get_property = g_inspector_cell_renderer_get_property;


  g_object_class_install_property (gobject_class,
                                   PROP_GTYPE,
                                   g_param_spec_ulong ("gtype",
						       "GType",
						       "GType to render",
						       0,
						       G_MAXULONG,
						       G_TYPE_INVALID,
						       G_PARAM_WRITABLE));

  g_object_class_install_property (gobject_class,
                                   PROP_POINTER,
                                   g_param_spec_pointer ("pointer",
							 "Pointer",
							 "Pointer to render",
							 G_PARAM_WRITABLE));

#if 0
  g_object_class_install_property (gobject_class,
                                   PROP_TEXT,
                                   g_param_spec_string ("text",
							"Text",
							"Text to render",
							NULL,
							G_PARAM_WRITABLE));
#endif
}

static void
g_inspector_cell_renderer_init (GInspectorCellRenderer *inspector_cell_renderer)
{
#if 0
  GTK_CELL_RENDERER (inspector_cell_renderer)->xalign = 0.0;
  GTK_CELL_RENDERER (inspector_cell_renderer)->yalign = 0.5;
  GTK_CELL_RENDERER (inspector_cell_renderer)->xpad = 2;
#endif
  GTK_CELL_RENDERER (inspector_cell_renderer)->ypad = 0;
}

static void
g_inspector_cell_renderer_set_property (GObject      *object,
					guint         param_id,
					const GValue *value,
					GParamSpec   *pspec)
{
  GtkCellRendererText *cell_text_renderer;

  cell_text_renderer = GTK_CELL_RENDERER_TEXT (object);


  switch (param_id)
    {
    case PROP_GTYPE:
      {
	if (cell_text_renderer->text)
	  g_free (cell_text_renderer->text);

	cell_text_renderer->text
	  = g_strdup (g_type_name (g_value_get_ulong (value)));

	g_object_notify (object, "gtype");
      }
      break;

    case PROP_POINTER:
      {
	if (cell_text_renderer->text)
	  g_free (cell_text_renderer->text);

	cell_text_renderer->text
	  = g_strdup_printf ("%p", g_value_get_pointer (value));

	g_object_notify (object, "pointer");
      }
      break;

    default:
      {
	G_OBJECT_WARN_INVALID_PROPERTY_ID (object, param_id, pspec);
      }
      break;
    }
}

static void
g_inspector_cell_renderer_get_property (GObject    *object,
					guint       param_id,
					GValue     *value,
					GParamSpec *pspec)
{
}


GtkCellRenderer *
g_inspector_cell_renderer_new (void)
{
  return g_object_new (G_INSPECTOR_TYPE_CELL_RENDERER, NULL);
}
