/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspectorcontext.h"


enum {
  ACTIVATE,
  DEACTIVATE,
  LAST_SIGNAL
};

enum {
  PROP_0,
  PROP_VALUE,
};


static void g_inspector_context_set_property (GObject      *object,
					      guint         prop_id,
					      const GValue *value,
					      GParamSpec   *pspec);
static void g_inspector_context_get_property (GObject      *object,
					      guint         prop_id,
					      GValue       *value,
					      GParamSpec   *pspec);


static guint inspector_context_signals[LAST_SIGNAL] = { 0 };


G_DEFINE_TYPE (GInspectorContext, g_inspector_context, G_TYPE_OBJECT);


static void
g_inspector_context_class_init (GInspectorContextClass *klass)
{
  GObjectClass *gobject_class;
  GObjectClass *object_class;
  GInspectorContextClass *inspector_context_class;

  gobject_class = G_OBJECT_CLASS (klass);
  object_class = (GObjectClass*) klass;
  inspector_context_class = (GInspectorContextClass*) klass;

  gobject_class->set_property = g_inspector_context_set_property;
  gobject_class->get_property = g_inspector_context_get_property;
  inspector_context_class->activate   = NULL;
  inspector_context_class->deactivate = NULL;


  inspector_context_signals[ACTIVATE] =
    g_signal_new ("activate",
                  G_TYPE_FROM_CLASS (gobject_class),
                  G_SIGNAL_RUN_FIRST,
                  G_STRUCT_OFFSET (GInspectorContextClass, activate),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__VOID,
                  G_TYPE_NONE, 0);

  inspector_context_signals[DEACTIVATE] =
    g_signal_new ("deactivate",
                  G_TYPE_FROM_CLASS (gobject_class),
                  G_SIGNAL_RUN_FIRST,
                  G_STRUCT_OFFSET (GInspectorContextClass, deactivate),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__VOID,
                  G_TYPE_NONE, 0);
}

static void
g_inspector_context_init (GInspectorContext *context)
{
  context->active = FALSE;
}

static void
g_inspector_context_set_property (GObject      *object,
				  guint         prop_id,
				  const GValue *value,
				  GParamSpec   *pspec)
{
  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
g_inspector_context_get_property (GObject    *object,
				  guint       prop_id,
				  GValue     *value,
				  GParamSpec *pspec)
{
  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

void
g_inspector_context_activate (GInspectorContext *context)
{
  g_return_if_fail (context != NULL);
  g_return_if_fail (G_IS_INSPECTOR_CONTEXT (context));

  if (context->active == FALSE)
    {
      context->active = TRUE;

      g_signal_emit (context, inspector_context_signals[ACTIVATE], 0);
    }
}

void
g_inspector_context_deactivate (GInspectorContext *context)
{
  g_return_if_fail (context != NULL);
  g_return_if_fail (G_IS_INSPECTOR_CONTEXT (context));

  if (context->active == TRUE)
    {
      context->active = FALSE;

      g_signal_emit (context, inspector_context_signals[DEACTIVATE], 0);
    }
}
