/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "gtkrootpointbutton.h"

#include "glrr-glib.h"
#include "glrr-gtk.h"



static void builtin_module_init (void);

static gpointer procedure_marching (gpointer data,
				    gpointer func_data,
				    gpointer invoke_data);



void
g_inspector_builtin_register_module_misc_marching (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-misc-marching";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("marching-widget-bbox",
				  "Marching Widget BBox",
				  G_INSPECTOR_PROCEDURE_TYPE_MISC,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  GTK_TYPE_WIDGET,
				  procedure_marching,
				  NULL);
}



static void     marching               (GtkWidget               *widget);
static gboolean timeout_handler        (gpointer                 data);
static void     element_holder_changed (GInspectorElementHolder *element_holder,
					gpointer                 user_data);

static GInspectorElementHolder *marching_element_holder = NULL;



static gpointer
procedure_marching (gpointer data,
		    gpointer func_data,
		    gpointer invoke_data)
{
  GtkWidget *widget;


  widget = GTK_WIDGET (data);


  marching (widget);


  return NULL;
}

static void
marching (GtkWidget *widget)
{
  if (marching_element_holder == NULL)
    {
      {
	marching_element_holder = g_inspector_element_holder_new ();
      }

      {
	g_signal_connect (marching_element_holder,
			  "changed",
			  G_CALLBACK (element_holder_changed),
			  NULL);
      }

      {
	GClosure *closure;
	GSource *source;

	closure = g_cclosure_new_object (G_CALLBACK (timeout_handler),
					 G_OBJECT (marching_element_holder));

	source = g_timeout_source_new (250);

	g_source_set_closure (source, closure);
	g_source_attach (source, NULL);
	g_source_unref (source);
      }
    }

  if (widget != NULL)
    {
      g_inspector_element_holder_set_gobject (marching_element_holder,
                                              G_OBJECT (widget));
      g_object_weak_ref (G_OBJECT (widget),
			 (GWeakNotify)g_inspector_element_holder_unset,
			 marching_element_holder);
      g_object_set_data (G_OBJECT (marching_element_holder),
			 "count",
			 GUINT_TO_POINTER (0));
    }
  else
    {
      g_inspector_element_holder_unset (marching_element_holder);
    }
}

static gboolean
timeout_handler (gpointer data)
{
  GInspectorElementHolder *element_holder;
  GtkWidget *widget;
  guint count;

  element_holder = G_INSPECTOR_ELEMENT_HOLDER (data);
  widget = g_inspector_element_holder_get_element (element_holder);
  count = GPOINTER_TO_UINT (g_object_get_data (G_OBJECT (element_holder),
					       "count"));

  if ((widget != NULL) &&
      (GTK_WIDGET_REALIZED (widget)) &&
      (GTK_WIDGET_MAPPED   (widget)) &&
      (GTK_WIDGET_VISIBLE  (widget)) &&
      (gtk_widget_get_child_visible (widget)))
    {
      gint x;
      gint y;
      gint width;
      gint height;

      if (GTK_WIDGET_NO_WINDOW (widget))
	{
	  x = widget->allocation.x;
	  y = widget->allocation.y;
	}
      else
	{
	  x = 0;
	  y = 0;
	}

      width  = widget->allocation.width;
      height = widget->allocation.height;

      {
	GdkGC *fg_gc;
	GdkGC *bg_gc;
	GdkColor fg_color;
	GdkColor bg_color;

	fg_gc = gdk_gc_new (widget->window);
	bg_gc = gdk_gc_new (widget->window);

	gdk_gc_set_line_attributes (fg_gc,
				    1,
				    GDK_LINE_ON_OFF_DASH,
				    GDK_CAP_BUTT,
				    GDK_JOIN_MITER);
	gdk_gc_set_dashes (fg_gc,
			   count,
			   "\4\4",
			   2);


	fg_color.pixel = 0;
	fg_color.red   = 0;
	fg_color.green = 0;
	fg_color.blue  = 0;

	bg_color.pixel = 0;
	bg_color.red   = 0xffff;
	bg_color.green = 0xffff;
	bg_color.blue  = 0;

	gdk_gc_set_rgb_fg_color (fg_gc, &fg_color);
	gdk_gc_set_rgb_fg_color (bg_gc, &bg_color);

	gdk_draw_rectangle (widget->window,
			    bg_gc,
			    FALSE,
			    x,
			    y,
			    (width  - 1),
			    (height - 1));
	gdk_draw_rectangle (widget->window,
			    fg_gc,
			    FALSE,
			    x,
			    y,
			    (width  - 1),
			    (height - 1));

	g_object_unref (fg_gc);
	g_object_unref (bg_gc);
      }
    }

  ++count;

  g_object_set_data (G_OBJECT (element_holder),
		     "count",
		     GUINT_TO_POINTER (count));


  return TRUE;
}

static void
element_holder_changed (GInspectorElementHolder *element_holder,
			gpointer                 user_data)
{
  GInspectorElementType element_type;
  gpointer element;
  GtkWidget *widget;
  GtkWidget *prev_widget;

  element_type = g_inspector_element_holder_get_element_type (element_holder);
  element      = g_inspector_element_holder_get_element      (element_holder);

  widget = GTK_WIDGET (element);
  prev_widget = g_object_get_data (G_OBJECT (element_holder),
				   "prev-widget");

  if (prev_widget != NULL)
    {
      gtk_widget_queue_draw (prev_widget);
    }

  g_object_set_data (G_OBJECT (element_holder),
		     "prev-widget",
		     widget);
}
