/*
 *
 *  $Id: reconstructioninteractor.h 3395 2011-02-23 13:05:49Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <vtkDebugLeaks.h>
#include <vtkInteractorStyleImage.h>


class GinkgoInteractorStyleReconstruction : public vtkInteractorStyleImage
{
public:
	static GinkgoInteractorStyleReconstruction *New();

	vtkTypeRevisionMacro(GinkgoInteractorStyleReconstruction, vtkInteractorStyleImage);

	virtual void OnMouseMove();
	virtual void OnLeftButtonDown();
	virtual void OnLeftButtonUp();
	virtual void OnMiddleButtonDown();
	virtual void OnMiddleButtonUp();
	virtual void OnRightButtonDown();
	virtual void OnRightButtonUp();
	virtual void OnMouseWheelForward();
	virtual void OnMouseWheelBackward();
	virtual void OnChar();

	vtkSetMacro (WindowStep, double);
	vtkGetMacro (WindowStep, double);

	vtkSetMacro (LevelStep,  double);
	vtkGetMacro (LevelStep,  double);


	virtual void WindowLevel ();
	virtual void WindowLevelWheelForward ();
	virtual void WindowLevelWheelBackward ();

protected:
	GinkgoInteractorStyleReconstruction();
	virtual ~GinkgoInteractorStyleReconstruction();

private:
	double                 WindowStep;
	double                 LevelStep;

};

