#pragma once


#include "glightvisualizatorviewbase.h"
#include <lightvisualizator/export/itoolwindowlevellight.h>

class wxBitmap;

namespace LightVisualizator {
	class LightVisualizatorView;
	namespace GUI {
		class VTKInternalMembers;
		class ImagePanel;
		class GLightVisualizatorView: public GNC::GCS::IObservador, public GLightVisualizatorViewBase, public LightVisualizator::IContratoWindowLevelLight {
		public:
			GLightVisualizatorView(LightVisualizator::LightVisualizatorView* pView);
			~GLightVisualizatorView();

			virtual void LoadImageCanvas();
			virtual void OnZoomChoice(wxCommandEvent &event);
			virtual void OnSize(wxSizeEvent& event);
			virtual void RefreshPipeline();
			virtual void SetZoom(int zoom, bool force = false);

			virtual void OnScrollSeries(wxScrollEvent &event);
			virtual void OnPaintView( wxPaintEvent& event );
			virtual void OnFocus(wxFocusEvent &event);
			virtual void OnKeyDown( wxKeyEvent& event );
			virtual void OnMouseWheel( wxMouseEvent& event );
			void GoToSlice(int i);
			virtual void SetSlice(int vid, bool force = false);

			virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);

			ImagePanel *m_pImagePanel;
			wxBitmap* m_pBitmap;
			VTKInternalMembers* pInternalMembers;

			LightVisualizator::LightVisualizatorView * View;
			int m_zoom;
		};
	}
}