/*
 *  $Id: FooExtensionController.h 3681 2011-04-12 10:53:31Z tovar $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */
#pragma once

#include <api/icontroladormodulo.h>

namespace FooExtension {

	class ContenedorHerramientas;

	//Defines extension capabilities and is the entry point for extension workflows
	class FooExtensionController : public GNC::GCS::IControladorModulo {
	public:

		/* Constructor */
		FooExtensionController(GNC::GCS::IEntorno* pEntorno);

		/* Destructor */
		virtual ~FooExtensionController();

		//It's mandatory to implement this method, here you have to register views of this module, this will register FooView.
		virtual void RegistrarVistas();

		//it's call by Ginkgo CADx core when this extension has to open a series with required module and required Diagnostic Study UID
		virtual GNC::GCS::IVista* AbrirVista(int modo, ListaDescriptoresSerie& series, const std::string& uidEstudioDiagnostico = "");

		//it supports importation workflow?
		virtual bool SoportaImportacion() const;

		//return importation steps, importation workflow is structured as a wizard Process, each step implements IPasoWizard interface, typical importation
		//process starts with image selection step, all steps has image path list (m_pListaFicheros)
		virtual void GetPasosImportacion(IWizard* pWizard,std::list<IPasoWizard*> &listaPasos, wxWindow* pParent, std::string &dirTemporal,GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion);

	protected:
		
	};

}
