/*
 *  
 *  $Id: wwindowlevel.cpp 4478 2011-12-13 11:55:00Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */

#include <cmath>

#include <api/globals.h>
#include "wwindowlevel.h"
#include <main/managers/widgetsmanager.h>
#include <api/westilo.h>

#include <vtkgl.h>


//region "Implementacion de WWindowLevelBuilder"

GNC::GCS::Widgets::WWindowLevelBuilder::WWindowLevelBuilder(GNC::GCS::IWidgetsManager* pManager, const GNC::GCS::TriggerButton& buttonMask, long gid) : GNC::GCS::Widgets::IWidgetBuilder(pManager, buttonMask, gid)
{
	m_pObservador = NULL;
	m_MouseDown = false;
}

GNC::GCS::Widgets::WWindowLevelBuilder::~WWindowLevelBuilder()
{
}

void GNC::GCS::Widgets::WWindowLevelBuilder::OnMouseEvents(GNC::GCS::Eventos::EventoRaton& evento)
{
	if (!m_pManager) {
		return;
	}
	if (m_MouseDown && evento.ButtonUp(m_ButtonMask)) {
		m_MouseDown = false;

		TVector stop(evento.sX, evento.sY);
		if (m_pObservador != NULL) {
			m_pObservador->OnAjuste(m_Start, stop);
		}
		if (m_pObservador != NULL) {
			m_pObservador->OnEnd();
		}
		ConsumirEvento();
		//m_pManager->Modificado();
	}
	else if (evento.ButtonDown(m_ButtonMask)) {

		m_MouseDown = true;

		if (m_pObservador != NULL) {
			m_pObservador->OnStart();
		}
		m_Start.Asignar(evento.sX, evento.sY);

		//m_pManager->Modificado();
		ConsumirEvento();
	}
	else if (evento.Dragging() && m_MouseDown) {
		TVector stop(evento.sX, evento.sY);
		if (m_pObservador != NULL) {
			m_pObservador->OnAjuste(m_Start, stop);
		}

		//m_pManager->Modificado();
		ConsumirEvento();
	}
	else if( evento.Moving() ){
		GTRACE("Moviendose");
		m_NodoMoviendose.Asignar(evento.sX, evento.sY);
	}

	GTRACE("GNC::GCS::Widgets::WWindowLevelBuilder::OnMouseEvents(wxMouseEvent&)");
}

void GNC::GCS::Widgets::WWindowLevelBuilder::OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&)
{
	GTRACE("GNC::GCS::Widgets::WWindowLevelBuilder::OnKeyEvents(wxKeyEvent&)");
}

void GNC::GCS::Widgets::WWindowLevelBuilder::Render(GNC::GCS::Contexto3D* /*c*/)
{

}

GNC::GCS::Widgets::TipoCursor GNC::GCS::Widgets::WWindowLevelBuilder::GetCursor()
{
	return GNC::GCS::Widgets::CUR_WINDOW_LEVEL;
}

//endregion
