/*
 *  
 *  $Id: herramientaangulo.cpp 4869 2012-04-19 11:47:15Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/menu.h>
#include <wx/sizer.h>
#include <wx/dc.h>
#include <wx/aui/auibar.h>
#include <wx/xml/xml.h>
#include <api/globals.h>

#include <api/iwidgetsmanager.h>
#include "herramientaangulo.h"
#include <widgets/wangulo.h>
#include <resources/ginkgoresourcemanager.h>

#include <iostream>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>

#define TIPO_NORMAL 1211
#define TIPO_COBB   1212

//----------------------------------------------------------------------
namespace GNC {
	namespace GUI {
		class EventHandlerAngleTools: public wxEvtHandler {
		public:
			EventHandlerAngleTools(wxWindow* pParent, GNC::HerramientaAngulo* pHerramienta):wxEvtHandler()
			{
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;
				// Connect Events
				m_pParent->Connect(TIPO_NORMAL, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerAngleTools::OnTipoAnguloNormalClick),NULL,this);
				m_pParent->Connect(TIPO_COBB, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerAngleTools::OnTipoAnguloCobbClick),NULL,this);
			}

			~EventHandlerAngleTools()
			{
				m_pParent->Disconnect(TIPO_NORMAL, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerAngleTools::OnTipoAnguloNormalClick),NULL,this);
				m_pParent->Disconnect(TIPO_COBB, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerAngleTools::OnTipoAnguloCobbClick),NULL,this);
			}

			
			virtual void OnTipoAnguloNormalClick(wxCommandEvent& event){
				m_pHerramienta->SetTipo(GNC::HerramientaAngulo::TA_Normal);
				event.Skip(false);
			}

			virtual void OnTipoAnguloCobbClick(wxCommandEvent& event){
				m_pHerramienta->SetTipo(GNC::HerramientaAngulo::TA_Cobb);
				event.Skip(false);
			}		

			GNC::HerramientaAngulo* m_pHerramienta;
			wxWindow* m_pParent;
		};

		class MenuItemAngle : public wxMenuItem {
		public:
			MenuItemAngle(wxWindow* pParent, long id, const wxString& nombre, const wxBitmap& bitmap, wxMenu* pMenuPadre, GNC::HerramientaAngulo* pHerramienta):wxMenuItem(pMenuPadre,id,nombre,nombre,wxITEM_NORMAL) {
				pEventHandler = new EventHandlerAngleTools(pParent,pHerramienta);
#ifdef __WXMSW__
				SetBitmaps(bitmap);
				//#else
				//	SetBitmap(GinkgoResourcesManager::BarraRejilla::GetIcoVerRejilla());
#endif
			}

			~MenuItemAngle() {
				if(pEventHandler != NULL) {
					delete pEventHandler;
					pEventHandler = NULL;
				}
			}

			EventHandlerAngleTools* pEventHandler;
		};


		class HerramientaOpcionesAnguloGUI : public AUI_NAMESPACE wxAuiToolBar {
		public:
			HerramientaOpcionesAnguloGUI(wxWindow* pParent, HerramientaAngulo* pHerramienta) : AUI_NAMESPACE wxAuiToolBar(pParent,wxID_ANY, wxDefaultPosition, wxDefaultSize,AUI_NAMESPACE wxAUI_TB_DEFAULT_STYLE )
			{
				m_pHerramienta=pHerramienta;

				SetToolBitmapSize( wxSize( 16,16 ) );

				AddLabel(wxID_ANY, _("Type"), 25);

				AddTool( TIPO_NORMAL, _("Normal"), GinkgoResourcesManager::BarraAngulo::GetIcoAnguloNormal(), _("Normal Angle (3 points)"),wxITEM_CHECK );
				ToggleTool(TIPO_NORMAL,true);
				AddTool( TIPO_COBB, _("Cobb"), GinkgoResourcesManager::BarraAngulo::GetIcoAnguloCobb(), _("Cobb Angle (2 straight lines)"), wxITEM_CHECK );

				Realize();

				Layout();

				// Connect Events
				this->Connect( TIPO_NORMAL, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesAnguloGUI::OnTipoAnguloNormalClick ) );
				this->Connect( TIPO_COBB, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesAnguloGUI::OnTipoAnguloCobbClick ) );

			};

			~HerramientaOpcionesAnguloGUI() {
				this->Disconnect( TIPO_COBB, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesAnguloGUI::OnTipoAnguloCobbClick ) );
				this->Disconnect( TIPO_NORMAL, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesAnguloGUI::OnTipoAnguloNormalClick ) );

			};

			virtual void OnTipoAnguloNormalClick(wxCommandEvent& event){
				m_pHerramienta->SetTipo(GNC::HerramientaAngulo::TA_Normal);
				ToggleTool(TIPO_NORMAL,true);
				ToggleTool(TIPO_COBB,false);
				event.Skip(false);
			}

			virtual void OnTipoAnguloCobbClick(wxCommandEvent& event){
				m_pHerramienta->SetTipo(GNC::HerramientaAngulo::TA_Cobb);
				ToggleTool(TIPO_NORMAL,false);
				ToggleTool(TIPO_COBB,true);
				event.Skip(false);
			}
		protected:
			GNC::HerramientaAngulo* m_pHerramienta;
		};
	};
};

GNC::HerramientaAngulo::HerramientaAngulo()
{
	m_Activa = false;
	m_TipoAngulo = TA_Normal;
	m_Descripcion = _Std("Angle\tCtrl+A");
	m_AcceleratorCode = m_Descripcion[m_Descripcion.size() - 1];
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoAngulo();
	m_pAnguloBuilder = NULL;
	m_IsDropDown = true;
}

GNC::HerramientaAngulo::~HerramientaAngulo()
{
}

wxXmlNode* GNC::HerramientaAngulo::Serializar(GNC::GCS::IVista* pVista, long vid, const std::string nombreMedicoSerializa)
{

	typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;
	//se cogen todas los widgets regla de los contratos con ese vid
	GNC::GCS::ListaWidgets listaWidgets;
	for (ICConcreto::IteradorMapaContratos it = ICConcreto::m_Contratos.begin(); it != ICConcreto::m_Contratos.end(); it++) {
		if((*it).first == pVista){
			for (ICConcreto::IteradorListaContratos it2 = (*it).second->begin(); it2 != (*it).second->end(); it2++) {
				GNC::GCS::IContratoWidgets* pC = (*it2);
				GNC::GCS::ListaWidgets listaWidgetsTmp;
				if(pC->GetManager() != NULL){
					pC->GetManager()->GetListaWidgetsSubVista(vid,listaWidgetsTmp);
					listaWidgets.splice(listaWidgets.begin(),listaWidgetsTmp);
				}
			}
		}
	}

	wxXmlNode* resultado = NULL;
	if(listaWidgets.size()>0){
		resultado = new wxXmlNode(NULL,wxXML_ELEMENT_NODE,wxT("angle"));
		resultado->AddProperty(wxT("id"),wxString::Format(wxT("%d"),this->ID));
		for (GNC::GCS::IWidgetsManager::IteradorListaWidgets it = listaWidgets.begin();  it!= listaWidgets.end(); it++){
			GNC::GCS::Widgets::WAngulo* pAngulo = dynamic_cast<GNC::GCS::Widgets::WAngulo*>((*it));
			if( pAngulo != NULL){
				resultado->AddChild(pAngulo->Serializar(nombreMedicoSerializa));
			}
		}
	}
	return resultado;
}

void GNC::HerramientaAngulo::Deserializar(GNC::GCS::IVista* pVista, long vid, wxXmlNode* nodo)
{
	if(nodo->GetPropVal(wxT("id"),wxT("")) != wxString::Format(wxT("%d"),this->ID)){
		std::cerr<< "Ha ocurrido un error al desserializar la herramienta angulo"<<std::endl;
	}

	typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;

	for (ICConcreto::IteradorMapaContratos it = ICConcreto::m_Contratos.begin(); it != ICConcreto::m_Contratos.end(); it++) {
		if((*it).first == pVista){

			for (ICConcreto::IteradorListaContratos it2 = (*it).second->begin(); it2 != (*it).second->end(); it2++) {
				GNC::GCS::IContratoWidgets* pC = (*it2);

				GNC::GCS::ListaWidgets listaWidgets;

				wxXmlNode *child = nodo->GetChildren();
				while (child) {
					GNC::GCS::Widgets::WAngulo* pAngulo = new GNC::GCS::Widgets::WAngulo(pC->GetManager(), vid, child);
					listaWidgets.push_back(pAngulo);
					child = child->GetNext();
				}

				for (GNC::GCS::IWidgetsManager::IteradorListaWidgets itWidgets = listaWidgets.begin();  itWidgets!= listaWidgets.end(); itWidgets++){
					pC->GetManager()->InsertarWidget((*itWidgets),false);
				}
			}
		}
	}
}

wxCursor GNC::HerramientaAngulo::GetCursor(){
	return wxCursor(wxCURSOR_CROSS);
}

void GNC::HerramientaAngulo::SetTipo(TipoAngulo tipo)
{
	if (m_TipoAngulo != tipo) {
		m_TipoAngulo = tipo;
		if (m_pAnguloBuilder != NULL) {
			if (m_TipoAngulo == TA_Normal) {
				m_pAnguloBuilder->SetModo(GNC::GCS::Widgets::MA_Normal);
			}
			else {
				m_pAnguloBuilder->SetModo(GNC::GCS::Widgets::MA_Cobb);
			}
		}
	}

}

//region "Realizacion de la interfaz IHerramienta"

void GNC::HerramientaAngulo::CrearPaneles(wxPanel* )
{
	m_pAbstractPanelHerramientaOpciones = NULL;
}
bool GNC::HerramientaAngulo::AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent)
{
	pMenuParent->Append(new GNC::GUI::MenuItemAngle(pParent,TIPO_NORMAL,_("Normal Angle (3 points)"), GinkgoResourcesManager::BarraAngulo::GetIcoAnguloNormal(),pMenuParent,this));
	pMenuParent->Append(new GNC::GUI::MenuItemAngle(pParent,TIPO_COBB,_("Cobb Angle (2 straight lines)"), GinkgoResourcesManager::BarraAngulo::GetIcoAnguloCobb(),pMenuParent,this));
	return true;
}

wxBitmap GNC::HerramientaAngulo::GetIcono()
{
	switch (m_TipoAngulo) {
		case TA_Cobb:
			return GinkgoResourcesManager::BarraAngulo::GetIcoAnguloCobb();
		case TA_Normal:
		default:
			return GinkgoResourcesManager::BarraAngulo::GetIcoAnguloNormal();
	}
}

void GNC::HerramientaAngulo::ConectarContratoFalso(bool activar)
{
	typedef GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;
	if (ICConcreto::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	for (ICConcreto::IteradorListaContratos it = ICConcreto::m_pListaActiva->begin(); it != ICConcreto::m_pListaActiva->end(); it++) {
		GNC::GCS::IContratoWidgets* pC = (*it);
		if (pC->Inicializado()) {
			if (activar) {
				GTRACE("HerramientaAngulo: Conectando contrato falso de vista " << ICConcreto::m_pVistaActiva);
				pC->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			} else {
				GTRACE("HerramientaAngulo: Desconectando contrato falso de vista " << ICConcreto::m_pVistaActiva);
				pC->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			}
		}
	}
}

void GNC::HerramientaAngulo::SetVistaActiva(GNC::GCS::IVista* pVista)
{
	GNC::GCS::IContratable<GNC::GCS::IContratoWidgets>::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaAngulo::SetVistaActiva(" << pVista << ")");
}

void GNC::HerramientaAngulo::ConectarContratos(bool activar)
{
	typedef GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;
	if (ICConcreto::m_pListaActiva == NULL) {
		if (activar) {
			std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		} else {
			if (m_pAnguloBuilder != NULL)
			{
				delete m_pAnguloBuilder;
				m_pAnguloBuilder = NULL;
			}
		}
		return;
	}

	for (ICConcreto::IteradorListaContratos it = ICConcreto::m_pListaActiva->begin(); it != ICConcreto::m_pListaActiva->end(); it++) {
		GNC::GCS::IContratoWidgets* pC = (*it);
		if (pC->Inicializado()) {
			if (activar) {
				GTRACE("HerramientaAngulo: Conectando contratos de vista " << ICConcreto::m_pVistaActiva);
				m_pAnguloBuilder = new GNC::GCS::Widgets::WAnguloBuilder(pC->GetManager(), GetTriggerButton());
				if (m_TipoAngulo == TA_Normal) {
					m_pAnguloBuilder->SetModo(GNC::GCS::Widgets::MA_Normal);
				}
				else {
					m_pAnguloBuilder->SetModo(GNC::GCS::Widgets::MA_Cobb);
				}
				pC->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(m_pAnguloBuilder->GetCursor());
			} else {
				GTRACE("HerramientaAngulo: Desconectando contratos de vista " << ICConcreto::m_pVistaActiva);
				pC->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				if (m_pAnguloBuilder != NULL)
				{
					delete m_pAnguloBuilder;
					m_pAnguloBuilder = NULL;
				}
			}
		}
	}
}

//endregion


//region "Eventos refinados desde los paneles"

//endregion
