/*
 *  
 *  $Id: panelconfiguracionhce.cpp 4774 2012-03-07 13:21:14Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <vector>
#include <sstream>

#include <endpoint/endpoint.h>

#include <wx/msgdlg.h>
#include <wx/msgout.h>
#include <wx/filename.h>
#include <main/controllers/configurationcontroller.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/log.h>
#include <wx/busyinfo.h>
#include <wx/xml/xml.h>

#include <main/controllers/xmlrpccontroller.h>

#ifndef _WIN32
#include <signal.h>
#endif

#include "panelconfiguracionhce.h"


GNC::GUI::PanelConfiguracionHCE::PanelConfiguracionHCE(wxWindow* pParent,IDialogoConfiguracion* pDialogo): PanelConfiguracionHCEBase(pParent), IPasoConfiguracion(pDialogo)
{
	Recargar();
}

GNC::GUI::PanelConfiguracionHCE::~PanelConfiguracionHCE()
{
}

void GNC::GUI::PanelConfiguracionHCE::Recargar()
{
	std::string value;
	GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/HCE","IDOrganizacionReceptora", value);
	m_pIdOrganizacionReceptora->SetValue(wxString::FromUTF8(value.c_str()));
	GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/HCE","IDSistemaPeticionario", value);
	m_pIdSistemaPeticionario->SetValue(wxString::FromUTF8(value.c_str()));
	GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/HCE","IDAplicacionRellenadora", value);
	m_pIdAplicacionRellenadora->SetValue(wxString::FromUTF8(value.c_str()));
	GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/HCE","IDGinkgoApplication", value, "GINKGO");
	m_pIdGinkgoAplication->SetValue(wxString::FromUTF8(value.c_str()));
	GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/HCE","HostnameMI", value);
	m_pHostnameMI->SetValue(wxString::FromUTF8(value.c_str()));
	GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/HCE","PuertoMI", value);
	m_pPuertoMI->SetValue(wxString::FromUTF8(value.c_str()));

	bool boolValue;
	GNC::GCS::ConfigurationController::Instance()->readBoolGeneral("/GinkgoCore/HCE","XMLRPCServerEnabled", boolValue, false);
	m_pCheckXMLRPC->SetValue(boolValue);

	GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/HCE","XMLRPCServerPort", value);
	m_pRPCPort->SetValue(wxString::FromUTF8(value.c_str()));
	
	m_pPortXMLPanel->Enable(m_pCheckXMLRPC->GetValue());
}

//region "Metodos de IPasoConfiguracion"
wxWindow* GNC::GUI::PanelConfiguracionHCE::GetPanel()
{
	return this;
}

std::string GNC::GUI::PanelConfiguracionHCE::GetTitle()
{
	return _Std("Electronic health record");
}

std::string GNC::GUI::PanelConfiguracionHCE::GetCabecera()
{
	return _Std("Setting the electronic health record system");
}

bool GNC::GUI::PanelConfiguracionHCE::Validar()
{
	bool ok = true;
	std::stringstream sstream;

	long tmpLong;
	if (m_pPortXMLPanel->IsEnabled()) {
		if (!m_pRPCPort->GetValue().ToLong(&tmpLong)) {
			ok = false;
			sstream << _Std("You have to set a valid port") ;
		}
	} else {
		if (!m_pRPCPort->GetValue().ToLong(&tmpLong)) {
			m_pRPCPort->SetValue(wxEmptyString);
		}
	}
	if (!ok) {
		wxMessageBox(wxString::FromUTF8(sstream.str().c_str()),_("Info"),wxOK | wxICON_INFORMATION, this);
	}

	//reset xml-rpc server
	return ok;
}

bool GNC::GUI::PanelConfiguracionHCE::Guardar()
{
	GNC::GCS::ConfigurationController::Instance()->writeStringGeneral("/GinkgoCore/HCE","IDOrganizacionReceptora", std::string(m_pIdOrganizacionReceptora->GetValue().ToUTF8()));
	GNC::GCS::ConfigurationController::Instance()->writeStringGeneral("/GinkgoCore/HCE","IDSistemaPeticionario", std::string(m_pIdSistemaPeticionario->GetValue().ToUTF8()));
	GNC::GCS::ConfigurationController::Instance()->writeStringGeneral("/GinkgoCore/HCE","IDAplicacionRellenadora", std::string(m_pIdAplicacionRellenadora->GetValue().ToUTF8()));
	GNC::GCS::ConfigurationController::Instance()->writeStringGeneral("/GinkgoCore/HCE","IDGinkgoApplication", std::string(m_pIdGinkgoAplication->GetValue().ToUTF8()));
	GNC::GCS::ConfigurationController::Instance()->writeStringGeneral("/GinkgoCore/HCE","IDGinkgoApplication", std::string(m_pIdGinkgoAplication->GetValue().ToUTF8()));
	GNC::GCS::ConfigurationController::Instance()->writeStringGeneral("/GinkgoCore/HCE","HostnameMI", std::string(m_pHostnameMI->GetValue().ToUTF8()));
	GNC::GCS::ConfigurationController::Instance()->writeStringGeneral("/GinkgoCore/HCE","PuertoMI", std::string(m_pPuertoMI->GetValue().ToUTF8()));
	GNC::GCS::ConfigurationController::Instance()->writeBoolGeneral("/GinkgoCore/HCE","XMLRPCServerEnabled", m_pCheckXMLRPC->GetValue());
	GNC::GCS::ConfigurationController::Instance()->writeStringGeneral("/GinkgoCore/HCE","XMLRPCServerPort", std::string(m_pRPCPort->GetValue().ToUTF8()));

	m_pRPCPort->Enable(m_pCheckXMLRPC->GetValue());

	if (m_pCheckXMLRPC->GetValue()) {
		GIL::XMLRPC::XMLRPCController::StartServer();
	} else {
		GIL::XMLRPC::XMLRPCController::FreeInstance();
	}
	
	return true;
}

void GNC::GUI::PanelConfiguracionHCE::OnTextoCambiado(wxCommandEvent &)
{
	OnPropiedadCambiada();
}

void GNC::GUI::PanelConfiguracionHCE::OnCambioSistema(wxCommandEvent &)
{
	OnPropiedadCambiada();
}

void GNC::GUI::PanelConfiguracionHCE::OnTestClick(wxCommandEvent &)
{
	//se abre una conexión tcp al host(puerto...)
	std::string url;
	{
		std::ostringstream ostr;
		ostr << m_pHostnameMI->GetValue().ToUTF8()<< ":" << m_pPuertoMI->GetValue().ToUTF8();
		url = ostr.str();
	}
	#ifndef _WIN32
	signal(SIGPIPE, SIG_IGN);
	#endif
	EndpointAddrlist::g_default_family = AF_INET;

	Endpoint::Initialize();

	wxBusyInfo* info = new wxBusyInfo(_("Testing conectivity with the server..."));
	Endpoint ep(TCP | CLIENT, url);
	delete info;

	if (!ep) {
		wxLogError(wxString::FromUTF8(ep.m_error_str.c_str()));
		std::stringstream ostr;
		ostr << _Std("Error connecting to url") << url;
		wxMessageBox(wxString::FromUTF8(ostr.str().c_str()), _("Connection test fail"), wxICON_ERROR, this);
	} else {
		wxMessageBox(_("Connection test successful"),_("Info"),wxOK | wxICON_INFORMATION, this);
	}
	ep.Close();
}

void GNC::GUI::PanelConfiguracionHCE::OnCheckXMLRPC(wxCommandEvent&)
{
	OnPropiedadCambiada();
	m_pPortXMLPanel->Enable(m_pCheckXMLRPC->GetValue());
}

//endregion
