/*
 *  
 *  $Id: icontroladorautenticacion.h 4687 2012-02-10 13:35:07Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <string>
#include <exception>
#include <ostream>

class IModeloDicom;
namespace GNC {
	namespace GCS {
		class IEntorno;
	}
	class IProxyNotificadorProgreso;
}

namespace GSEC {
	namespace Auth {

		class AuthException : GNC::GCS::IException {
		public:
			AuthException(const std::string& msg, const std::string& componente="GSEC/Auth", bool fatal = true) : GNC::GCS::IException(msg, componente, fatal)
			{
			}
			~AuthException() throw()
			{
			}

			const std::string& GetComponent() const
			{
				return component;
			}

			const std::string& GetCause() const {
				return cause;
			}

			std::string GetFullCause() const {
				return *this;
			}

			bool IsFatal()  const {
				return fatal;
			}

			operator std::string () const {
				return std::string("Excepcion en componente ") + GetComponent() + std::string(": ")  + GetCause();
			}

			friend std::ostream& operator<<(std::ostream& out, const AuthException& ex)
			{
				out << (const std::string&) ex;
				return out;
			}

			friend std::ostream& operator<<(std::ostream& out, const AuthException* ex)
			{
				if (ex != NULL) {
					out << *ex;
				}
				else {
					out << "(NULL)";
				}
				return out;
			}

		protected:
			std::string cause;
			std::string component;
			bool fatal;
		};

		class IControladorAutenticacion {
		public:

			virtual bool Auth (const std::string& usuario, const std::string& password) = 0;

		protected:

			IControladorAutenticacion()
			{
			}

			~IControladorAutenticacion()
			{
			}

			
		};
	}
}
