/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  toolbutton.cc - GtkToolButton C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "toolbutton.hh"
#include "private/toolbuttonclass.hh"
#include "private/marshal.hh"
#include "stockid.hh"
#include "widget.hh"

using namespace GFC;

/*  Gtk::ToolButton
 */

Gtk::ToolButton::ToolButton(GtkToolButton *tool_button, bool owns_reference)
: ToolItem((GtkToolItem*)tool_button, owns_reference)
{
}

Gtk::ToolButton::ToolButton()
: ToolItem((GtkToolItem*)ToolButtonClass::create())
{
}	

Gtk::ToolButton::ToolButton(Widget& icon_widget)
: ToolItem((GtkToolItem*)ToolButtonClass::create())
{
	set_icon_widget(&icon_widget);
}	
	
Gtk::ToolButton::ToolButton(const char *label, bool use_underline)
: ToolItem((GtkToolItem*)ToolButtonClass::create())
{
	set_label(label, use_underline);
}
	
Gtk::ToolButton::ToolButton(const String& label, bool use_underline)
: ToolItem((GtkToolItem*)ToolButtonClass::create())
{
	set_label(label, use_underline);
}	
	
Gtk::ToolButton::ToolButton(Widget& icon_widget, const char *label, bool use_underline)
: ToolItem((GtkToolItem*)ToolButtonClass::create())
{
	set_contents(icon_widget, label, use_underline);
}
	
Gtk::ToolButton::ToolButton(Widget& icon_widget, const String& label, bool use_underline)
: ToolItem((GtkToolItem*)ToolButtonClass::create())
{
	set_contents(icon_widget, label, use_underline);
}	
 	
Gtk::ToolButton::ToolButton(const StockId& stock_id)
: ToolItem((GtkToolItem*)ToolButtonClass::create())
{
	set_stock_id(stock_id);
}

Gtk::ToolButton::~ToolButton()
{
}

String 
Gtk::ToolButton::get_label() const
{
	return gtk_tool_button_get_label(gtk_tool_button());
}

String 
Gtk::ToolButton::get_stock_id() const
{
	return gtk_tool_button_get_stock_id(gtk_tool_button());
}
	
Gtk::Widget* 
Gtk::ToolButton::get_icon_widget() const
{
	GtkWidget *widget = gtk_tool_button_get_icon_widget(gtk_tool_button());
	return widget ? G::Object::wrap<Widget>(widget) : 0;
}
	
Gtk::Widget* 
Gtk::ToolButton::get_label_widget() const
{
	GtkWidget *widget = gtk_tool_button_get_label_widget(gtk_tool_button());
	return widget ? G::Object::wrap<Widget>(widget) : 0;
}

void 
Gtk::ToolButton::set_label(const char *label, bool use_underline)
{
	gtk_tool_button_set_label(gtk_tool_button(), label);
	if (use_underline)
		set_use_underline(use_underline);
}

void 
Gtk::ToolButton::set_label(const String& label, bool use_underline)
{
	set_label(label.c_str(), use_underline);
}

void 
Gtk::ToolButton::set_stock_id(const StockId& stock_id)
{
	gtk_tool_button_set_stock_id(gtk_tool_button(), stock_id);
}

void 
Gtk::ToolButton::set_icon_widget(Widget *icon_widget)
{
	gtk_tool_button_set_icon_widget(gtk_tool_button(), icon_widget->gtk_widget());
}

void 
Gtk::ToolButton::set_label_widget(Widget *label_widget)
{
	gtk_tool_button_set_label_widget(gtk_tool_button(), label_widget->gtk_widget());
}

void 
Gtk::ToolButton::set_contents(Widget& icon_widget, const char *label, bool use_underline)
{
	set_label(label, use_underline);	
	set_icon_widget(&icon_widget);
	icon_widget.show();	
}
	
void 
Gtk::ToolButton::set_contents(Widget& icon_widget, const String& label, bool use_underline)
{
	set_contents(icon_widget, label.c_str(), use_underline);	
}

/*  Gtk::ToolButton signals
 */

const Gtk::ToolButton::ClickedSignalType Gtk::ToolButton::clicked_signal("clicked", (GCallback)&G::Marshal::void_callback);

