#ifndef SUBSPACE_H_INCLUDED
#define SUBSPACE_H_INCLUDED

#include "vektor.h"
#include "polynomial.h"

class Subspace
{
  int n;//ambient dimension
  PolynomialSet basis;
 public:
  Subspace(IntegerVectorList const &generators, int ambientDimension=-1);
  bool contains(IntegerVector const &v)const;
  int dimension();
  friend Subspace sum(Subspace const &a, Subspace const &b);
  int ambientDimension();
  IntegerVectorList getRepresentation()const;
  IntegerVector canonicalizeVector(IntegerVector const &v)const;
};

#endif
